/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.FileRangeException;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.plugins.server.Cleanable;
import org.jboss.resteasy.plugins.server.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.NoContent;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class FileProvider
implements MessageBodyReader<File>,
AsyncMessageBodyWriter<File> {
    private static final String PREFIX = "pfx";
    private static final String SUFFIX = "sfx";
    private String _downloadDirectory = null;

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class == type;
    }

    @Override
    public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        Cleanables cleanables;
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        Path downloadedFile = null;
        if (this._downloadDirectory != null) {
            try {
                downloadedFile = Files.createTempFile(Paths.get(this._downloadDirectory, new String[0]), PREFIX, SUFFIX, new FileAttribute[0]);
            }
            catch (IOException ex) {
                LogMessages.LOGGER.couldNotBindToDirectory(this._downloadDirectory);
            }
        }
        if (downloadedFile == null) {
            downloadedFile = Files.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        }
        if ((cleanables = ResteasyContext.getContextData(Cleanables.class)) != null) {
            cleanables.addCleanable(new FileHolder(downloadedFile));
        } else {
            LogMessages.LOGGER.temporaryFileCreated(downloadedFile.toString());
        }
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return downloadedFile.toFile();
        }
        try (OutputStream output = Files.newOutputStream(downloadedFile, new OpenOption[0]);){
            ProviderHelper.writeTo(entityStream, output);
        }
        return downloadedFile.toFile();
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.isAssignableFrom(type) && !MediaTypeHelper.isBlacklisted(mediaType);
    }

    @Override
    public long getSize(File o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return o.length();
    }

    @Override
    public void writeTo(File uploadFile, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        HttpHeaders headers = ResteasyContext.getContextData(HttpHeaders.class);
        if (headers == null) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        String range = headers.getRequestHeaders().getFirst("Range");
        if (range == null) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        int byteUnit = (range = range.trim()).indexOf("bytes=");
        if (byteUnit < 0) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        if ((range = range.substring("bytes=".length())).indexOf(44) > -1) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        int separator = range.indexOf(45);
        if (separator < 0) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
        if (separator == 0) {
            long begin;
            long fileSize = uploadFile.length();
            if (fileSize + (begin = Long.parseLong(range)) < 1L) {
                this.writeIt(uploadFile, entityStream);
                return;
            }
            throw new FileRangeException(mediaType, uploadFile, fileSize + begin, fileSize - 1L);
        }
        try {
            long end;
            long fileSize = uploadFile.length();
            long begin = Long.parseLong(range.substring(0, separator));
            if (begin >= fileSize) {
                throw new WebApplicationException(416);
            }
            if (range.endsWith("-")) {
                end = fileSize - 1L;
            } else {
                String substring = range.substring(separator + 1);
                end = Long.parseLong(substring);
            }
            throw new FileRangeException(mediaType, uploadFile, begin, end);
        }
        catch (NumberFormatException e) {
            this.writeIt(uploadFile, entityStream);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeIt(File uploadFile, OutputStream entityStream) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(uploadFile));){
            ProviderHelper.writeTo((InputStream)inputStream, entityStream);
        }
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(File uploadFile, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        HttpHeaders headers = ResteasyContext.getContextData(HttpHeaders.class);
        if (headers == null) {
            return this.writeIt(uploadFile, entityStream);
        }
        String range = headers.getRequestHeaders().getFirst("Range");
        if (range == null) {
            return this.writeIt(uploadFile, entityStream);
        }
        int byteUnit = (range = range.trim()).indexOf("bytes=");
        if (byteUnit < 0) {
            return this.writeIt(uploadFile, entityStream);
        }
        if ((range = range.substring("bytes=".length())).indexOf(44) > -1) {
            return this.writeIt(uploadFile, entityStream);
        }
        int separator = range.indexOf(45);
        if (separator < 0) {
            return this.writeIt(uploadFile, entityStream);
        }
        if (separator == 0) {
            long begin;
            long fileSize = uploadFile.length();
            if (fileSize + (begin = Long.parseLong(range)) < 1L) {
                return this.writeIt(uploadFile, entityStream);
            }
            return ProviderHelper.completedException(new FileRangeException(mediaType, uploadFile, fileSize + begin, fileSize - 1L));
        }
        try {
            long end;
            long fileSize = uploadFile.length();
            long begin = Long.parseLong(range.substring(0, separator));
            if (begin >= fileSize) {
                throw new WebApplicationException(416);
            }
            if (range.endsWith("-")) {
                end = fileSize - 1L;
            } else {
                String substring = range.substring(separator + 1);
                end = Long.parseLong(substring);
            }
            return ProviderHelper.completedException(new FileRangeException(mediaType, uploadFile, begin, end));
        }
        catch (NumberFormatException e) {
            return this.writeIt(uploadFile, entityStream);
        }
    }

    protected CompletionStage<Void> writeIt(File uploadFile, AsyncOutputStream entityStream) {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(uploadFile));
            return ProviderHelper.writeToAndCloseInput(inputStream, entityStream);
        }
        catch (FileNotFoundException e) {
            return ProviderHelper.completedException(e);
        }
    }

    private static class FileHolder
    implements Cleanable {
        final Path file;

        FileHolder(Path file) {
            this.file = file;
        }

        @Override
        public void clean() throws Exception {
            Files.deleteIfExists(this.file);
        }
    }
}

