/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.NoContent;
import org.jboss.resteasy.util.ReadFromStream;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class ByteArrayProvider
implements MessageBodyReader<byte[]>,
AsyncMessageBodyWriter<byte[]> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isArray() && type.getComponentType().equals(Byte.TYPE);
    }

    @Override
    public byte[] readFrom(Class<byte[]> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return new byte[0];
        }
        return ReadFromStream.readFromStream(1024, entityStream);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isArray() && type.getComponentType().equals(Byte.TYPE) && !MediaTypeHelper.isBlacklisted(mediaType);
    }

    @Override
    public long getSize(byte[] bytes, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return bytes.length;
    }

    @Override
    public void writeTo(byte[] bytes, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
        entityStream.write(bytes);
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(byte[] bytes, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
        return entityStream.asyncWrite(bytes);
    }
}

