/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@PreMatching
public class CorsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    protected boolean allowCredentials = true;
    protected String allowedMethods;
    protected String allowedHeaders;
    protected String exposedHeaders;
    protected int corsMaxAge = -1;
    protected Set<String> allowedOrigins = new HashSet<String>();

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String origin = requestContext.getHeaderString("Origin");
        if (origin == null) {
            return;
        }
        if (requestContext.getMethod().equalsIgnoreCase("OPTIONS")) {
            this.preflight(origin, requestContext);
        } else {
            this.checkOrigin(requestContext, origin);
        }
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String origin = requestContext.getHeaderString("Origin");
        if (origin == null || requestContext.getMethod().equalsIgnoreCase("OPTIONS") || requestContext.getProperty("cors.failure") != null) {
            return;
        }
        responseContext.getHeaders().putSingle("Access-Control-Allow-Origin", origin);
        responseContext.getHeaders().putSingle("Vary", "Origin");
        if (this.isAllowCredentials()) {
            responseContext.getHeaders().putSingle("Access-Control-Allow-Credentials", "true");
        }
        if (this.getExposedHeaders() != null) {
            responseContext.getHeaders().putSingle("Access-Control-Expose-Headers", this.getExposedHeaders());
        }
    }

    protected void preflight(String origin, ContainerRequestContext requestContext) throws IOException {
        String allowHeaders;
        String requestMethods;
        this.checkOrigin(requestContext, origin);
        Response.ResponseBuilder builder = Response.ok();
        builder.header("Access-Control-Allow-Origin", origin);
        builder.header("Vary", "Origin");
        if (this.isAllowCredentials()) {
            builder.header("Access-Control-Allow-Credentials", "true");
        }
        if ((requestMethods = requestContext.getHeaderString("Access-Control-Request-Method")) != null) {
            if (this.getAllowedMethods() != null) {
                requestMethods = this.getAllowedMethods();
            }
            builder.header("Access-Control-Allow-Methods", requestMethods);
        }
        if ((allowHeaders = requestContext.getHeaderString("Access-Control-Request-Headers")) != null) {
            if (this.getAllowedHeaders() != null) {
                allowHeaders = this.getAllowedHeaders();
            }
            builder.header("Access-Control-Allow-Headers", allowHeaders);
        }
        if (this.getCorsMaxAge() > -1) {
            builder.header("Access-Control-Max-Age", this.getCorsMaxAge());
        }
        requestContext.abortWith(builder.build());
    }

    protected void checkOrigin(ContainerRequestContext requestContext, String origin) {
        if (!this.getAllowedOrigins().contains("*") && !this.getAllowedOrigins().contains(origin)) {
            requestContext.setProperty("cors.failure", true);
            throw new ForbiddenException(Messages.MESSAGES.originNotAllowed(origin));
        }
    }
}

