/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.RootClassNode;
import org.jboss.resteasy.core.registry.RootNode;
import org.jboss.resteasy.plugins.server.resourcefactory.JndiResourceFactory;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyUriBuilderImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriBuilder;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.metadata.ResourceMethod;
import org.jboss.resteasy.spi.statistics.StatisticsController;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.AnnotationResolver;
import org.jboss.resteasy.util.GetRestful;
import org.jboss.resteasy.util.IsHttpMethod;

public class ResourceMethodRegistry
implements Registry {
    public static final String REGISTRY_MATCHING_EXCEPTION = "registry.matching.exception";
    protected ResteasyProviderFactory providerFactory;
    protected RootClassNode root = new RootClassNode();
    protected boolean widerMatching;
    protected RootNode rootNode = new RootNode();
    protected ResourceBuilder resourceBuilder;
    protected StatisticsController statisticsController;

    public ResourceMethodRegistry(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.resourceBuilder = providerFactory.getResourceBuilder();
        this.statisticsController = providerFactory.getStatisticsController();
    }

    public boolean isWiderMatching() {
        return this.widerMatching;
    }

    public void setWiderMatching(boolean widerMatching) {
        this.widerMatching = widerMatching;
    }

    public void addPerRequestResource(Class clazz, String basePath) {
        this.addResourceFactory((ResourceFactory)new POJOResourceFactory(this.resourceBuilder, clazz), basePath);
    }

    public void addPerRequestResource(Class clazz) {
        this.addResourceFactory(new POJOResourceFactory(this.resourceBuilder, clazz));
    }

    @Override
    public void addPerRequestResource(Class<?> clazz, ResourceBuilder resourceBuilder) {
        this.addResourceFactory((ResourceFactory)new POJOResourceFactory(resourceBuilder, clazz), resourceBuilder);
    }

    @Override
    public void addPerRequestResource(ResourceClass clazz) {
        POJOResourceFactory resourceFactory = new POJOResourceFactory(this.resourceBuilder, clazz);
        this.register(resourceFactory, null, clazz);
        resourceFactory.registered(this.providerFactory);
    }

    @Override
    public void addPerRequestResource(ResourceClass clazz, String basePath) {
        POJOResourceFactory resourceFactory = new POJOResourceFactory(this.resourceBuilder, clazz);
        this.register(resourceFactory, basePath, clazz);
        resourceFactory.registered(this.providerFactory);
    }

    @Override
    public void addSingletonResource(Object singleton) {
        ResourceClass resourceClass = this.resourceBuilder.getRootResourceFromAnnotations(singleton.getClass());
        this.addResourceFactory(new SingletonResource(singleton, resourceClass));
    }

    @Override
    public void addSingletonResource(Object singleton, String basePath) {
        ResourceClass resourceClass = this.resourceBuilder.getRootResourceFromAnnotations(singleton.getClass());
        this.addResourceFactory((ResourceFactory)new SingletonResource(singleton, resourceClass), basePath);
    }

    @Override
    public void addSingletonResource(Object singleton, ResourceClass resourceClass) {
        SingletonResource resourceFactory = new SingletonResource(singleton, resourceClass);
        this.register(resourceFactory, null, resourceClass);
        resourceFactory.registered(this.providerFactory);
    }

    @Override
    public void addSingletonResource(Object singleton, ResourceClass resourceClass, String basePath) {
        SingletonResource resourceFactory = new SingletonResource(singleton, resourceClass);
        this.register(resourceFactory, basePath, resourceClass);
        resourceFactory.registered(this.providerFactory);
    }

    @Override
    public void addJndiResource(String jndiName) {
        this.addResourceFactory(new JndiResourceFactory(jndiName));
    }

    @Override
    public void addJndiResource(String jndiName, String basePath) {
        this.addResourceFactory((ResourceFactory)new JndiResourceFactory(jndiName), basePath);
    }

    @Override
    public void addJndiResource(String jndiName, ResourceClass resourceClass) {
        JndiResourceFactory resourceFactory = new JndiResourceFactory(jndiName);
        this.register(resourceFactory, null, resourceClass);
        resourceFactory.registered(this.providerFactory);
    }

    @Override
    public void addJndiResource(String jndiName, ResourceClass resourceClass, String basePath) {
        JndiResourceFactory resourceFactory = new JndiResourceFactory(jndiName);
        this.register(resourceFactory, basePath, resourceClass);
        resourceFactory.registered(this.providerFactory);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref) {
        this.addResourceFactory(ref, (String)null);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, ResourceBuilder resourceBuilder) {
        this.addResourceFactory(ref, resourceBuilder, null);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base) {
        this.addResourceFactory(ref, this.resourceBuilder, base);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, ResourceBuilder resourceBuilder, String base) {
        Class<?> clazz = ref.getScannableClass();
        Class<?> restful = AnnotationResolver.getClassWithAnnotation(clazz, resourceBuilder.getCorrespondingRootAnnotation());
        if (restful == null) {
            Object msg = Messages.MESSAGES.classIsNotRootResource(clazz.getName());
            for (Class<?> intf : clazz.getInterfaces()) {
                msg = (String)msg + " " + intf.getName();
            }
            throw new RuntimeException((String)msg);
        }
        this.addResourceFactory(ref, resourceBuilder, base, restful);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base, Class<?> clazz) {
        this.addResourceFactory(ref, this.resourceBuilder, base, clazz);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, ResourceBuilder resourceBuilder, String base, Class<?> clazz) {
        Class[] classes = new Class[]{clazz};
        this.addResourceFactory(ref, resourceBuilder, base, classes);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base, Class<?>[] classes) {
        this.addResourceFactory(ref, this.resourceBuilder, base, classes);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, ResourceBuilder resourceBuilder, String base, Class<?>[] classes) {
        if (ref != null) {
            ref.registered(this.providerFactory);
        }
        for (Class<?> clazz : classes) {
            if (Proxy.isProxyClass(clazz)) {
                for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                    ResourceClass resourceClass = resourceBuilder.getRootResourceFromAnnotations((Class<?>)genericDeclaration);
                    this.register(ref, base, resourceClass);
                }
                continue;
            }
            ResourceClass resourceClass = resourceBuilder.getRootResourceFromAnnotations(clazz);
            this.register(ref, base, resourceClass);
        }
        for (Class<?> clazz : classes) {
            for (GenericDeclaration genericDeclaration : this.getDeclaredMethods(clazz)) {
                Method _method = resourceBuilder.getAnnotatedMethod(clazz, (Method)genericDeclaration);
                if (_method == null || Modifier.isPublic(_method.getModifiers())) continue;
                LogMessages.LOGGER.JAXRSAnnotationsFoundAtNonPublicMethod(((Method)genericDeclaration).getDeclaringClass().getName(), ((Method)genericDeclaration).getName());
            }
        }
    }

    private Method[] getDeclaredMethods(final Class<?> clazz) {
        Method[] methodList = new Method[]{};
        try {
            methodList = System.getSecurityManager() == null ? clazz.getDeclaredMethods() : AccessController.doPrivileged(new PrivilegedExceptionAction<Method[]>(){

                @Override
                public Method[] run() throws Exception {
                    return clazz.getDeclaredMethods();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return methodList;
    }

    @Override
    public void addResourceFactory(ResourceFactory rf, String base, ResourceClass resourceClass) {
        if (rf != null) {
            rf.registered(this.providerFactory);
        }
        this.register(rf, base, resourceClass);
    }

    protected void register(ResourceFactory rf, String base, ResourceClass resourceClass) {
        for (ResourceMethod resourceMethod : resourceClass.getResourceMethods()) {
            this.processMethod(rf, base, resourceMethod);
        }
        for (ResourceLocator resourceLocator : resourceClass.getResourceLocators()) {
            this.processMethod(rf, base, resourceLocator);
        }
    }

    @Override
    public void checkAmbiguousUri() {
        for (Map.Entry<String, List<ResourceInvoker>> entry : this.root.getBounded().entrySet()) {
            List<ResourceInvoker> values = entry.getValue();
            if (values.size() <= 1) continue;
            int locatorCnt = 0;
            int methodCnt = 0;
            for (ResourceInvoker rInvoker : values) {
                if (rInvoker instanceof ResourceLocatorInvoker) {
                    ++locatorCnt;
                    continue;
                }
                if (!(rInvoker instanceof ResourceMethodInvoker)) continue;
                ++methodCnt;
            }
            if (methodCnt <= 0 || locatorCnt <= 0) continue;
            StringBuilder sb = new StringBuilder();
            int cnt = values.size();
            for (int i = 0; i < cnt; ++i) {
                ResourceInvoker exp = values.get(i);
                sb.append(exp.getMethod().getDeclaringClass().getName()).append(".").append(exp.getMethod().getName());
                if (i >= cnt - 1) continue;
                sb.append(", ");
            }
            LogMessages.LOGGER.uriAmbiguity(entry.getKey(), sb.toString());
        }
    }

    protected void processMethod(ResourceFactory rf, String base, ResourceLocator method) {
        ResteasyUriBuilderImpl builder = new ResteasyUriBuilderImpl();
        if (base != null) {
            ((UriBuilder)builder).path(base);
        }
        ((UriBuilder)builder).path(method.getFullpath());
        String fullpath = ((ResteasyUriBuilder)builder).getPath();
        if (fullpath == null) {
            fullpath = "";
        }
        builder = new ResteasyUriBuilderImpl();
        if (base != null) {
            ((UriBuilder)builder).path(base);
        }
        ((UriBuilder)builder).path(method.getResourceClass().getPath());
        String classExpression = ((ResteasyUriBuilder)builder).getPath();
        if (classExpression == null) {
            classExpression = "";
        }
        InjectorFactory injectorFactory = this.providerFactory.getInjectorFactory();
        if (method instanceof ResourceMethod) {
            ResourceMethodInvoker invoker = new ResourceMethodInvoker((ResourceMethod)method, injectorFactory, rf, this.providerFactory);
            if (this.widerMatching) {
                this.rootNode.addInvoker(fullpath, invoker);
            } else {
                this.root.addInvoker(classExpression, fullpath, invoker);
            }
            this.statisticsController.register(invoker);
        } else {
            ResourceLocatorInvoker locator = new ResourceLocatorInvoker(rf, injectorFactory, this.providerFactory, method);
            if (this.widerMatching) {
                this.rootNode.addInvoker(fullpath, locator);
            } else {
                this.root.addInvoker(classExpression, fullpath, locator);
            }
            this.statisticsController.register(locator);
        }
    }

    public void removeRegistrations(Class clazz) {
        this.removeRegistrations(clazz, (String)null);
    }

    public void removeRegistrations(Class clazz, String base) {
        Class<?> restful = GetRestful.getRootResourceClass(clazz);
        this.removeRegistration(base, restful);
    }

    @Override
    public void removeRegistrations(ResourceClass resourceClass) {
        for (ResourceMethod resourceMethod : resourceClass.getResourceMethods()) {
            if (this.widerMatching) {
                this.rootNode.removeBinding(resourceMethod.getFullpath(), resourceMethod.getMethod());
                continue;
            }
            this.root.removeBinding(resourceClass.getPath(), resourceMethod.getFullpath(), resourceMethod.getMethod());
        }
        for (ResourceLocator resourceLocator : resourceClass.getResourceLocators()) {
            if (this.widerMatching) {
                this.rootNode.removeBinding(resourceLocator.getFullpath(), resourceLocator.getMethod());
                continue;
            }
            this.root.removeBinding(resourceClass.getPath(), resourceLocator.getFullpath(), resourceLocator.getMethod());
        }
    }

    private void removeRegistration(String base, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            String fullpath;
            Path path = method.getAnnotation(Path.class);
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (path == null && httpMethods == null) continue;
            ResteasyUriBuilderImpl builder = new ResteasyUriBuilderImpl();
            if (base != null) {
                ((UriBuilder)builder).path(base);
            }
            if (clazz.isAnnotationPresent(Path.class)) {
                ((UriBuilder)builder).path(clazz);
            }
            String classExpression = ((ResteasyUriBuilder)builder).getPath();
            if (path != null) {
                ((UriBuilder)builder).path(method);
            }
            if ((fullpath = ((ResteasyUriBuilder)builder).getPath()) == null) {
                fullpath = "";
            }
            if (this.widerMatching) {
                this.rootNode.removeBinding(fullpath, method);
                continue;
            }
            this.root.removeBinding(classExpression, fullpath, method);
        }
    }

    public Map<String, List<ResourceInvoker>> getBounded() {
        if (this.widerMatching) {
            return this.rootNode.getBounded();
        }
        return this.root.getBounded();
    }

    @Override
    public int getSize() {
        if (this.widerMatching) {
            return this.rootNode.getSize();
        }
        return this.root.getSize();
    }

    @Override
    public ResourceInvoker getResourceInvoker(HttpRequest request) {
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
        long timestamp = tracingLogger.timestamp("MATCH_SUMMARY");
        try {
            if (this.widerMatching) {
                ResourceInvoker resourceInvoker = this.rootNode.match(request, 0);
                return resourceInvoker;
            }
            ResourceInvoker resourceInvoker = this.root.match(request, 0);
            return resourceInvoker;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            tracingLogger.logDuration("MATCH_SUMMARY", timestamp, new Object[0]);
        }
    }
}

