/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.core.Configuration;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.resteasy.client.jaxrs.api.ClientBuilderConfiguration;
import org.jboss.resteasy.client.jaxrs.engines.PassthroughTrustManager;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;
import org.jboss.resteasy.client.jaxrs.internal.SslUtils;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.config.Options;

class DefaultClientBuilderConfiguration
implements ClientBuilderConfiguration {
    private final long connectionTTL;
    private final List<String> sniHostNames;
    private final String proxyHostName;
    private final int proxyPort;
    private final String proxyScheme;
    private final boolean cookieManagementEnabled;
    private final SSLContext sslContext;
    private final long readTimeout;
    private final long connectionTimeout;
    private final boolean isFollowRedirect;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Configuration configuration;

    DefaultClientBuilderConfiguration(ResteasyClientBuilderImpl builder) {
        this.connectionTTL = builder.getConnectionTTL(TimeUnit.MILLISECONDS);
        this.sniHostNames = List.copyOf(builder.getSniHostNames());
        this.proxyHostName = builder.getDefaultProxyHostname();
        this.proxyPort = builder.getDefaultProxyPort();
        this.proxyScheme = builder.getDefaultProxyScheme();
        this.cookieManagementEnabled = builder.isCookieManagementEnabled();
        this.sslContext = this.resolveSslContext(builder);
        this.readTimeout = builder.getReadTimeout(TimeUnit.MILLISECONDS);
        this.connectionTimeout = builder.getConnectionTimeout(TimeUnit.MILLISECONDS);
        this.isFollowRedirect = builder.isFollowRedirects();
        this.executorService = builder.asyncExecutor;
        this.scheduledExecutorService = builder.scheduledExecutorService;
        this.configuration = builder.getConfiguration();
    }

    static DefaultClientBuilderConfiguration create(ResteasyClientBuilderImpl builder) {
        return new DefaultClientBuilderConfiguration(builder);
    }

    @Override
    public long connectionIdleTime(TimeUnit unit) {
        return this.connectionTTL;
    }

    @Override
    public List<String> sniHostNames() {
        return this.sniHostNames;
    }

    @Override
    public String defaultProxyHostname() {
        return this.proxyHostName;
    }

    @Override
    public int defaultProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String defaultProxyScheme() {
        return this.proxyScheme;
    }

    @Override
    public boolean isCookieManagementEnabled() {
        return this.cookieManagementEnabled;
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public long readTimeout(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(this.readTimeout, unit);
    }

    @Override
    public long connectionTimeout(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(this.connectionTimeout, unit);
    }

    @Override
    public boolean isFollowRedirects() {
        return this.isFollowRedirect;
    }

    @Override
    public Optional<ExecutorService> executorService() {
        return Optional.ofNullable(this.executorService);
    }

    @Override
    public Optional<ScheduledExecutorService> scheduledExecutorService() {
        return Optional.ofNullable(this.scheduledExecutorService);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    private SSLContext resolveSslContext(ResteasyClientBuilderImpl resteasyClientBuilder) {
        try {
            SSLContext sslContext = null;
            if (resteasyClientBuilder.isTrustManagerDisabled()) {
                sslContext = DefaultClientBuilderConfiguration.resolveSslContext(resteasyClientBuilder.getConfiguration());
                sslContext.init(null, new TrustManager[]{new PassthroughTrustManager()}, null);
            } else if (resteasyClientBuilder.getSSLContext() != null) {
                sslContext = resteasyClientBuilder.getSSLContext();
            } else if (resteasyClientBuilder.getKeyStore() != null || resteasyClientBuilder.getTrustStore() != null) {
                TrustManager[] trustManagers;
                KeyStore keyStore = resteasyClientBuilder.getKeyStore();
                KeyStore trustStore = resteasyClientBuilder.getTrustStore();
                sslContext = DefaultClientBuilderConfiguration.resolveSslContext(resteasyClientBuilder.getConfiguration());
                KeyManager[] keyManagers = keyStore != null ? new KeyManager[]{SslUtils.getKeyManager(keyStore, resteasyClientBuilder.getKeyStorePassword())} : SslUtils.getKeyManagers(null, resteasyClientBuilder.getKeyStorePassword());
                if (trustStore != null) {
                    if (resteasyClientBuilder.isTrustSelfSignedCertificates()) {
                        TrustSelfSignedTrustManager trustManager = new TrustSelfSignedTrustManager(SslUtils.getTrustManager(trustStore));
                        trustManagers = new TrustManager[]{trustManager};
                    } else {
                        trustManagers = SslUtils.getTrustManagers(trustStore);
                    }
                } else {
                    trustManagers = SslUtils.getTrustManagers(null);
                }
                sslContext.init(keyManagers, trustManagers, null);
            }
            return sslContext;
        }
        catch (Exception e) {
            throw Messages.MESSAGES.failedToResolveSSLContext(e);
        }
    }

    private static SSLContext resolveSslContext(Configuration configuration) throws NoSuchAlgorithmException {
        String protocol;
        Object protocolObject = configuration.getProperty(Options.CLIENT_SSL_CONTEXT_ALGORITHM.name());
        if (protocolObject == null) {
            protocol = DefaultClientBuilderConfiguration.getOptionValue(Options.CLIENT_SSL_CONTEXT_ALGORITHM);
        } else if (protocolObject instanceof String) {
            protocol = (String)protocolObject;
        } else {
            protocol = DefaultClientBuilderConfiguration.getOptionValue(Options.CLIENT_SSL_CONTEXT_ALGORITHM);
            LogMessages.LOGGER.invalidProtocol(protocolObject, protocol);
        }
        return SSLContext.getInstance(protocol);
    }

    private static <T> T getOptionValue(Options<T> option) {
        if (System.getSecurityManager() == null) {
            return option.getValue();
        }
        return (T)AccessController.doPrivileged(option::getValue);
    }

    private static class TrustSelfSignedTrustManager
    implements X509TrustManager {
        private final X509TrustManager delegate;

        TrustSelfSignedTrustManager(X509TrustManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (chain.length != 1) {
                this.delegate.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }
    }
}

