/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.webhook.WebhookDelivery;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Supports(value={nl.topicus.cobra.restcontract.security.Operation.READ})
@ClassDefaultTag(value={"miscellaneous"})
@CrudOperations(query=@CrudOperation(summary="Query for webhook deliveries", description="Queries over all deliveries for a webhook. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single webhook delivery", description="Returns the single webhook delivery."))
public interface WebhookDeliveryResource
extends KeyHubCrudRestResource<WebhookDelivery> {
    public static final String SUB_RESOURCE_PATH = "delivery";

    @POST
    @Path(value="{deliveryid:\\d+}/redeliver")
    @SecurityKey(value={KeyHubSecurityKeys.HasManageAccess.class})
    @Operation(tags={"miscellaneous"}, summary="Perform a redelivery of the webhook payload", description="Perform a redelivery of the webhook payload.", responses={@ApiResponse(responseCode="204", description="Webhook redelivered")})
    public void redeliver(@PathParam(value="deliveryid") long var1);
}

