/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Positive;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.simple.StringValue;
import nl.topicus.keyhub.servicecontract.model.vault.Vault;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecovery;
import nl.topicus.keyhub.servicecontract.resources.KeyHubRestResource;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordResource;

@ClassDefaultTag(value={"vault"})
public interface VaultResource
extends KeyHubRestResource {
    public static final String SUB_RESOURCE_PATH = "vault";

    @GET
    @Operation(summary="Read a vault with its records", description="Returns the vault. It is not possible to read the secrets, for this the records need to be read one by one.")
    @SecurityKey(value={KeyHubSecurityKeys.AccessVault.class})
    public Vault getVault();

    @GET
    @Operation(summary="Returns a random generated value", description="Returns a random generated value of the given length, default 24.")
    @Path(value="random")
    public StringValue random(@QueryParam(value="length") @DefaultValue(value="24") @Max(value=1024L) @Positive @Max(value=1024L) @Positive int var1);

    @GET
    @Operation(summary="Returns a random generated password", description="Returns a random generated password using the given strategy, or the default strategy if none given.")
    @Path(value="newpassword")
    public StringValue newpassword(@QueryParam(value="strategy") String var1);

    @POST
    @Path(value="recover")
    @SecurityKey(value={KeyHubSecurityKeys.KeyHubAdmin.class})
    @Operation(summary="Recover access to a vault", description="Recover access to a vault for a given account.", responses={@ApiResponse(responseCode="204", description="Access recovered")})
    public void recoverSecret(@Valid VaultRecovery var1);

    @DELETE
    @Operation(summary="Delete a personal vault", description="Delete the personal vault of the current user.", responses={@ApiResponse(responseCode="204", description="Vault removed")})
    public void deleteVault();

    @Path(value="record")
    public VaultRecordResource record();
}

