/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.annotations.SupportsFiltering;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.launchpad.VaultRecordLaunchpadTile;
import nl.topicus.keyhub.servicecontract.model.vault.MoveVaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.PasswordMetadata;
import nl.topicus.keyhub.servicecontract.model.vault.VaultActivationStatus;
import nl.topicus.keyhub.servicecontract.model.vault.VaultHolder;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordPrimer;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordSecrets;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordShareSummary;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE, Operation.DELETE})
@ClassDefaultTag(value={"vault"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new records in a vault", description="Creates one or more new vault records and returns the newly created records. Secrets are specified via the additional object secret. It is required to specify the 'topicus-Vault-session' header. When updating a TOTP-secret, make sure to set 'writeTotp' field."), query=@CrudOperation(summary="Query for records in a vault", description="Query for vault records in a specific vault. The various query parameters can be used to filter the response. It is not possible to access secrets with a query that returns multiple results. Secrets can only be read one by one."), read=@CrudOperation(summary="Read a single record by id", description="Returns the vault record identified by the id. When the 'secret' additonal object is requested, the 'topicus-Vault-session' header must be specified."), update=@CrudOperation(summary="Update a vault record", description="Updates the vault record identified by the id. To update the secrets, the 'secret' additional object must be used, in addition to specifying the 'topicus-Vault-session' header. When updating a TOTP-secret, make sure to set 'writeTotp' field."), delete=@CrudOperation(summary="Remove a vault record", description="Removes the vault record identified by the id. This cannot be undone."))
public interface VaultRecordResource
extends KeyHubCrudRestResource<VaultRecord> {
    public static final String SUB_RESOURCE_PATH = "record";
    public static final AdditionalObjectKey<VaultHolder> VAULTHOLDER = new AdditionalObjectKey("vaultholder");
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<VaultRecordSecrets> SECRETS = new AdditionalObjectKey("secret");
    public static final AdditionalObjectKey<LinkableWrapper<VaultRecordPrimer>> SHARES = new AdditionalObjectKey("shares");
    public static final AdditionalObjectKey<VaultRecordShareSummary> SHARE_SUMMARY = new AdditionalObjectKey("shareSummary");
    public static final AdditionalObjectKey<VaultRecordPrimer> PARENT = new AdditionalObjectKey("parent");
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<VaultRecordLaunchpadTile> LAUNCHPAD_TILE = new AdditionalObjectKey("tile");
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY)
    public static final AdditionalObjectKey<Boolean> DELETE_LAUNCHPAD_TILE = new AdditionalObjectKey("deleteTile");
    public static final AdditionalObjectKey<PasswordMetadata> PASSWORD_METADATA = new AdditionalObjectKey("passwordMetadata");
    public static final AdditionalObjectKey<VaultActivationStatus> ACTIVATION_STATUS = new AdditionalObjectKey("activationStatus");

    @Path(value="{recordid:\\d+}/move")
    @POST
    @io.swagger.v3.oas.annotations.Operation(tags={"vault"}, summary="Move, copy or share a vault record", description="Move, copy or share the vault record specified by the given id to/with a different vault. For this, the 'topicus-Vault-session' header must be set.", responses={@ApiResponse(responseCode="204", description="Vault record moved/copied/shared")})
    public void move(@PathParam(value="recordid") long var1, @Valid MoveVaultRecord var3);

    @POST
    @Path(value="export")
    @SecurityKey(value={KeyHubSecurityKeys.AccessVault.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Prepares an export of vault records in CSV format", description="Prepares an export of vault records using the filtering specified in the query parameters. The URI of the export can be found in the returned Location header. This URI is valid for 2 minutes after being generated.", responses={@ApiResponse(responseCode="202", description="Export prepared")})
    @SupportsFiltering(value=VaultRecord.class)
    public Response startExport();
}

