/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.Path;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.launchpad.VaultRecordLaunchpadTile;
import nl.topicus.keyhub.servicecontract.model.vault.PasswordMetadata;
import nl.topicus.keyhub.servicecontract.model.vault.VaultActivationStatus;
import nl.topicus.keyhub.servicecontract.model.vault.VaultHolder;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordPrimer;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordSecrets;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordShareSummary;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Path(value="/vaultrecord")
@Supports(value={Operation.READ})
@ClassDefaultTag(value={"vault"})
@CrudOperations(query=@CrudOperation(summary="Query for records over all vaults", description="Query for vault records over all vaults the user can access. The various query parameters can be used to filter the response. It is not possible to access secrets with a query that returns multiple results. Secrets can only be read one by one."), read=@CrudOperation(summary="Read a single record by id", description="Returns the vault record identified by the id. To access the secrets, use the full uri of the record. This endpoint does not support reading secrets."))
public interface VaultRecordQueryResource
extends KeyHubCrudRestResource<VaultRecord> {
    public static final String RESOURCE_PATH = "/vaultrecord";
    public static final AdditionalObjectKey<VaultHolder> VAULTHOLDER = new AdditionalObjectKey("vaultholder");
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<VaultRecordSecrets> SECRETS = new AdditionalObjectKey("secret");
    public static final AdditionalObjectKey<LinkableWrapper<VaultRecordPrimer>> SHARES = new AdditionalObjectKey("shares");
    public static final AdditionalObjectKey<VaultRecordShareSummary> SHARE_SUMMARY = new AdditionalObjectKey("shareSummary");
    public static final AdditionalObjectKey<VaultRecordPrimer> PARENT = new AdditionalObjectKey("parent");
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<VaultRecordLaunchpadTile> LAUNCHPAD_TILE = new AdditionalObjectKey("tile");
    public static final AdditionalObjectKey<PasswordMetadata> PASSWORD_METADATA = new AdditionalObjectKey("passwordMetadata");
    public static final AdditionalObjectKey<VaultActivationStatus> ACTIVATION_STATUS = new AdditionalObjectKey("activationStatus");
}

