/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import jakarta.validation.Valid;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.model.CobraSecurityKeys;
import nl.topicus.keyhub.servicecontract.annotations.ClientRestriction;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.config.LicenseKey;
import nl.topicus.keyhub.servicecontract.model.config.NotificationCentreSettings;
import nl.topicus.keyhub.servicecontract.model.config.Settings;
import nl.topicus.keyhub.servicecontract.model.config.VaultSetup;
import nl.topicus.keyhub.servicecontract.model.license.KeyHubInstalled;
import nl.topicus.keyhub.servicecontract.model.license.KeyHubLicenseInfo;
import nl.topicus.keyhub.servicecontract.model.license.KeyHubStatistics;
import nl.topicus.keyhub.servicecontract.resources.KeyHubRestResource;

@Path(value="/settings")
public interface SettingsResource
extends KeyHubRestResource {
    public static final String RESOURCE_PATH = "/settings";
    public static final String STATISTICS_PATH = "statistics";
    public static final String NOTIFICATION_CENTRE_PATH = "notificationcentre";
    public static final String VAULT_SETUP = "vaultsetup";
    public static final String INSTALLED = "installed";
    public static final String HEALTH = "health";
    public static final String PARSE_LICENSE = "parselicense";
    public static final String SUPPORT = "support";

    @GET
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "90111b5c-4bcc-4ef9-9199-111abeca7686", "Topicus Authenticator"})
    public Settings getSettings();

    @PUT
    @SecurityKey(value={KeyHubSecurityKeys.KeyHubAdmin.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa"})
    public Settings setSettings(@Valid Settings var1);

    @GET
    @Path(value="notificationcentre")
    @SecurityKey(value={KeyHubSecurityKeys.KeyHubAdmin.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "90111b5c-4bcc-4ef9-9199-111abeca7686", "Topicus Authenticator"})
    public NotificationCentreSettings getNotificationCentreSettings();

    @PUT
    @Path(value="notificationcentre")
    @SecurityKey(value={KeyHubSecurityKeys.KeyHubAdmin.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa"})
    public NotificationCentreSettings setNotificationCentreSettings(@Valid NotificationCentreSettings var1);

    @GET
    @Path(value="statistics")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa"})
    public KeyHubStatistics getStatistics();

    @PUT
    @SecurityKey(value={KeyHubSecurityKeys.ApplianceManager.class})
    @ClientRestriction(allowed={"90111b5c-4bcc-4ef9-9199-111abeca7686"})
    @Path(value="vaultsetup")
    public void setupVault(@Valid VaultSetup var1);

    @GET
    @SecurityKey(value={KeyHubSecurityKeys.ApplianceManager.class})
    @ClientRestriction(allowed={"90111b5c-4bcc-4ef9-9199-111abeca7686"})
    @Path(value="installed")
    public KeyHubInstalled installed();

    @GET
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    @ClientRestriction(allowed={"Topicus Authenticator"})
    @Path(value="health")
    public void checkHealth();

    @POST
    @Path(value="parselicense")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa"})
    @SecurityKey(value={KeyHubSecurityKeys.KeyHubAdmin.class})
    public KeyHubLicenseInfo parseLicense(@Valid LicenseKey var1);

    @GET
    @Produces(value={"text/plain"})
    @SecurityKey(value={KeyHubSecurityKeys.ApplianceManager.class})
    @ClientRestriction(allowed={"90111b5c-4bcc-4ef9-9199-111abeca7686"})
    @Path(value="support")
    public String getSupportStatistics();
}

