/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.BackendDeterminesDefault;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.annotations.SupportsFiltering;
import nl.topicus.keyhub.servicecontract.model.GeneratedSecret;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccount;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccountGroup;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccountStatus;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccountSupportedFeatures;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccountsAuditStats;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;
import nl.topicus.keyhub.servicecontract.resources.ServiceAccountGroupResource;

@Path(value="/serviceaccount")
@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE, Operation.DELETE})
@ClassDefaultTag(value={"provisioning"})
@CrudOperations(query=@CrudOperation(summary="Query for service accounts in Topicus KeyHub", description="Query for all service accounts in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single service account by id", description="Returns the service account identified by the id."), create=@CrudOperation(summary="Create one or more service accounts", description="Creates one or more new service accounts and returns the newly created service accounts."), update=@CrudOperation(summary="Update a service account", description="Updates the service account identified by the id."))
public interface ServiceAccountResource
extends KeyHubCrudRestResource<ServiceAccount> {
    public static final String RESOURCE_PATH = "/serviceaccount";
    @BackendDeterminesDefault
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<GeneratedSecret> SECRET = new AdditionalObjectKey("secret");
    public static final AdditionalObjectKey<LinkableWrapper<ServiceAccountGroup>> GROUPS = new AdditionalObjectKey("groups");
    public static final AdditionalObjectKey<ServiceAccountSupportedFeatures> SUPPORTED_FEATURES = new AdditionalObjectKey("supportedFeatures");

    @Path(value="{serviceaccountid:\\d+}/group")
    public ServiceAccountGroupResource groups(@PathParam(value="serviceaccountid") long var1);

    @PUT
    @Path(value="{serviceaccountid:\\d+}/status")
    @io.swagger.v3.oas.annotations.Operation(tags={"provisioning"}, summary="Updates the status toggle for the service account", description="Updates the status toggle for the service account. ", responses={@ApiResponse(responseCode="204", description="Service account updated")})
    public void updateStatus(@PathParam(value="serviceaccountid") long var1, @Valid ServiceAccountStatus var3);

    @POST
    @Path(value="{serviceaccountid:\\d+}/deactivate")
    @io.swagger.v3.oas.annotations.Operation(tags={"provisioning"}, summary="Deactivates the service account", description="Deactivates the service account. ", responses={@ApiResponse(responseCode="204", description="Service account deactivated")})
    public void deactivate(@PathParam(value="serviceaccountid") long var1);

    @Path(value="auditstats")
    @GET
    @SecurityKey(value={KeyHubSecurityKeys.Auditor.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Reads various service account based counts and statistics", description="Returns the counts and statistics of service accounts within Topicus KeyHub.")
    public ServiceAccountsAuditStats getAuditStats();

    @POST
    @Path(value="export")
    @SecurityKey(value={KeyHubSecurityKeys.Auditor.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Prepares an export of service accounts in CSV format", description="Prepares an export of service accounts using the filtering specified in the query parameters. The URI of the export can be found in the returned Location header. This URI is valid for 2 minutes after being generated.", responses={@ApiResponse(responseCode="202", description="Export prepared")})
    @SupportsFiltering(value=ServiceAccount.class)
    public Response startExport();

    @POST
    @Path(value="group/export")
    @SecurityKey(value={KeyHubSecurityKeys.Auditor.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Prepares an export of service account group on systems in CSV format", description="Prepares an export of service account group on systems using the filtering specified in the query parameters. The URI of the export can be found in the returned Location header. This URI is valid for 2 minutes after being generated.", responses={@ApiResponse(responseCode="202", description="Export prepared")})
    @SupportsFiltering(value=ServiceAccount.class)
    public Response startGroupExport();
}

