/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.client.OAuth2ClientPermissionWithClient;
import nl.topicus.keyhub.servicecontract.model.mark.ItemMarkers;
import nl.topicus.keyhub.servicecontract.model.provisioning.CircuitBreakerStatistics;
import nl.topicus.keyhub.servicecontract.model.provisioning.DeprovisionAction;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupOnSystemTypes;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedAccount;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystem;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisioningManagementPermissions;
import nl.topicus.keyhub.servicecontract.resources.GroupOnSystemResource;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;
import nl.topicus.keyhub.servicecontract.resources.ProvisionedAccountResource;

@Path(value="/system")
@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE})
@ClassDefaultTag(value={"provisioning"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new provisioned systems", description="Creates one or more new provisioned systems and returns the newly created systems."), query=@CrudOperation(summary="Query for provisioned systems in Topicus KeyHub", description="Query for all provisioned systems in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single provisioned system by id", description="Returns the provisioned system identified by the id."), update=@CrudOperation(summary="Update a provisioned system", description="Updates the provisioned system identified by the id."))
public interface ProvisionedSystemResource
extends KeyHubCrudRestResource<ProvisionedSystem> {
    public static final String RESOURCE_PATH = "/system";
    public static final AdditionalObjectKey<ProvisionedAccount> ACCOUNT = new AdditionalObjectKey("account");
    public static final AdditionalObjectKey<String> LOGIN_NAME = new AdditionalObjectKey("loginName");
    public static final AdditionalObjectKey<ItemMarkers> MARKERS = new AdditionalObjectKey("markers");
    public static final AdditionalObjectKey<GroupOnSystemTypes> SUPPORTED_GROUP_TYPES = new AdditionalObjectKey("supportedGroupTypes");
    public static final AdditionalObjectKey<LinkableWrapper<OAuth2ClientPermissionWithClient>> ISSUED_PERMISSIONS = new AdditionalObjectKey("issuedPermissions");
    public static final AdditionalObjectKey<CircuitBreakerStatistics> STATISTICS = new AdditionalObjectKey("statistics");
    public static final AdditionalObjectKey<ProvisioningManagementPermissions> MANAGEMENT_PERMISSIONS = new AdditionalObjectKey("managementPermissions");

    @Path(value="{systemid:\\d+}/account")
    public ProvisionedAccountResource accounts(@PathParam(value="systemid") long var1);

    @Path(value="{systemid:\\d+}/group")
    public GroupOnSystemResource groups(@PathParam(value="systemid") long var1);

    @POST
    @Path(value="{systemid:\\d+}/sync")
    @io.swagger.v3.oas.annotations.Operation(summary="Synchronize a provisioned system", description="Perform a full synchronization of the provisioned system specified by the given id. The synchronization runs in the background.", responses={@ApiResponse(responseCode="204", description="Synchronization started")})
    public void sync(@PathParam(value="systemid") long var1);

    @POST
    @Path(value="{systemid:\\d+}/deactivate")
    @io.swagger.v3.oas.annotations.Operation(summary="Deactivate a provisioned system", description="Deactivates the provisioned system specified by the given id. The action runs in the background.", responses={@ApiResponse(responseCode="204", description="System deactivated")})
    public void deactivate(@PathParam(value="systemid") long var1, @QueryParam(value="action") @DefaultValue(value="NONE") DeprovisionAction var3);
}

