/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.organization.OrganizationalUnit;
import nl.topicus.keyhub.servicecontract.model.organization.OrganizationalUnitPrimer;
import nl.topicus.keyhub.servicecontract.model.organization.OrganizationalUnitSettings;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;
import nl.topicus.keyhub.servicecontract.resources.OrganizationalUnitAccountResource;
import nl.topicus.keyhub.servicecontract.resources.OrganizationalUnitClientApplicationResource;

@Path(value="/organizationalunit")
@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE})
@ClassDefaultTag(value={"miscellaneous"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new organizational units", description="Creates one or more new organizational units and returns the newly created units."), query=@CrudOperation(summary="Query for organizational units in Topicus KeyHub", description="Query for all organizational units in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single organizational unit by id", description="Returns the organizational unit identified by the id."), update=@CrudOperation(summary="Update a organizational unit", description="Updates the organizational unit identified by the id."))
public interface OrganizationalUnitResource
extends KeyHubCrudRestResource<OrganizationalUnit> {
    public static final int MAX_DEPTH = 4;
    public static final String RESOURCE_PATH = "/organizationalunit";
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY)
    public static final AdditionalObjectKey<LinkableWrapper<OrganizationalUnitPrimer>> CREATE_AS_PARENT_OF = new AdditionalObjectKey("createAsParentOf");
    public static final AdditionalObjectKey<OrganizationalUnitSettings> RESOLVED_SETTINGS = new AdditionalObjectKey("settings");

    @Path(value="{organizationalunitid:\\d+}/account")
    public OrganizationalUnitAccountResource accounts(@PathParam(value="organizationalunitid") long var1);

    @Path(value="{organizationalunitid:\\d+}/client")
    public OrganizationalUnitClientApplicationResource clients(@PathParam(value="organizationalunitid") long var1);
}

