/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.ClientRestriction;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.request.AcceptModificationRequestParameters;
import nl.topicus.keyhub.servicecontract.model.request.Disable2FARequest;
import nl.topicus.keyhub.servicecontract.model.request.InitiatePasswordResetRequest;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequest;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequestReport;
import nl.topicus.keyhub.servicecontract.model.request.PasswordResetRequest;
import nl.topicus.keyhub.servicecontract.model.request.PasswordResetRequestStatus;
import nl.topicus.keyhub.servicecontract.model.request.ResetRequestAction;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Path(value="/request")
@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE})
@ClassDefaultTag(value={"miscellaneous"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new modification requests", description="Creates one or more new modification requests and returns the newly created requests."), query=@CrudOperation(summary="Query for modification requests", description="Queries over all modification requests. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single modification request", description="Returns the single modification request."), update=@CrudOperation(summary="Update a modification request", description="Updates the modification request identified by the id. Only the status and feedback can be updated and only when the request currently has status 'REQUESTED'."))
public interface ModificationRequestResource
extends KeyHubCrudRestResource<ModificationRequest> {
    public static final String RESOURCE_PATH = "/request";
    public static final String ACCEPT_PATH = "accept";
    public static final String REJECT_PATH = "reject";
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY)
    public static final AdditionalObjectKey<AcceptModificationRequestParameters> ACCEPT_PARAMETERS = new AdditionalObjectKey("acceptParams");
    public static final AdditionalObjectKey<PasswordResetRequestStatus> RESET_STATUS = new AdditionalObjectKey("resetStatus");

    @Path(value="2fa")
    @POST
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "90111b5c-4bcc-4ef9-9199-111abeca7686", "Topicus Authenticator"})
    public Response createDisable2FA(@Valid Disable2FARequest var1);

    @Path(value="pwdreset")
    @POST
    @SecurityKey(value={KeyHubSecurityKeys.InitiatePasswordReset.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public Response createPasswordReset(@Valid InitiatePasswordResetRequest var1);

    @Path(value="{requestid:\\d+}/cancel")
    @POST
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Cancel request", description="Cancel a modification request.", responses={@ApiResponse(responseCode="204", description="Request canceled")})
    public void cancel(@PathParam(value="requestid") long var1);

    @Path(value="{requestid:\\d+}/handlereset")
    @POST
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa"})
    public void handleResetRequest(@PathParam(value="requestid") long var1, @Valid PasswordResetRequest var3, @NotNull @QueryParam(value="action") ResetRequestAction var4);

    @Path(value="report")
    @POST
    public ModificationRequestReport report(@Valid ModificationRequest var1);
}

