/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.http.RequestRange;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.launchpad.DisplayedLaunchpadTiles;
import nl.topicus.keyhub.servicecontract.model.launchpad.LaunchpadTile;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Path(value="/launchpadtile")
@Supports(value={nl.topicus.cobra.restcontract.security.Operation.CREATE, nl.topicus.cobra.restcontract.security.Operation.READ, nl.topicus.cobra.restcontract.security.Operation.UPDATE, nl.topicus.cobra.restcontract.security.Operation.DELETE})
@ClassDefaultTag(value={"miscellaneous"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new launchpad tiles", description="Creates one or more new launchpad tiles and returns the newly created tiles."), query=@CrudOperation(summary="Query for launchpad tiles", description="Queries over all launchpad tiles. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single launchpad tile", description="Returns the single launchpad tile."), update=@CrudOperation(summary="Update a launchpad tile", description="Updates the launchpad tile identified by the id."), delete=@CrudOperation(summary="Remove a launchpad tile", description="Removes the specified launchpad tile."))
public interface LaunchpadTileResource
extends KeyHubCrudRestResource<LaunchpadTile> {
    public static final String RESOURCE_PATH = "/launchpadtile";

    @GET
    @Path(value="display")
    @Operation(tags={"miscellaneous"}, summary="Query tiles for display on the launchpad", description="Query tiles for display on the launchpad. This returns a normalized view over the tiles, per group. A single tile can be returned multiple times if access is given via multiple groups.", responses={@ApiResponse(responseCode="2XX", description="The tiles", content={@Content(schema=@Schema(implementation=DisplayedLaunchpadTiles.class))})})
    public Response display(@DefaultValue(value="items=0-99") @HeaderParam(value="Range") RequestRange var1, @QueryParam(value="modifiedSince") String var2, @QueryParam(value="filter") String var3, @QueryParam(value="group") Long var4);
}

