/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.auth.InternalAccount;
import nl.topicus.keyhub.servicecontract.model.auth.InternalAccountStatusObject;
import nl.topicus.keyhub.servicecontract.model.auth.MoveInternalAccount;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Supports(value={nl.topicus.cobra.restcontract.security.Operation.CREATE, nl.topicus.cobra.restcontract.security.Operation.READ, nl.topicus.cobra.restcontract.security.Operation.UPDATE, nl.topicus.cobra.restcontract.security.Operation.DELETE})
@ClassDefaultTag(value={"account"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new internal accounts within a directory", description="Creates one or more new internal accounts within a directory and returns the newly created accounts."), query=@CrudOperation(summary="Query for internal accounts within a directory", description="Queries over all internal accounts within a directory. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single internal accounts within a directory", description="Returns the single internal accounts within a directory."), update=@CrudOperation(summary="Update a internal accounts within a directory", description="Updates the internal accounts within a directory identified by the id."), delete=@CrudOperation(summary="Remove an internal accounts from a directory", description="Removes the specified internal accounts from a directory, including the associated KeyHub account."))
public interface InternalAccountResource
extends KeyHubCrudRestResource<InternalAccount> {
    public static final String SUB_RESOURCE_PATH = "internalaccount";
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY)
    public static final AdditionalObjectKey<String> CREATION_REASON = new AdditionalObjectKey("reason");

    @PUT
    @Path(value="{internalaccountid:\\d+}/status")
    @Operation(tags={"account"}, summary="Updates the status for the internal account", description="Updates the status for the internal account. Only the status 'NOT_ACTIVATED' can be set.", responses={@ApiResponse(responseCode="204", description="Account status updated")})
    public Response updateStatus(@PathParam(value="internalaccountid") long var1, @Valid InternalAccountStatusObject var3);

    @Path(value="{internalaccountid:\\d+}/move")
    @POST
    @Operation(tags={"vault"}, summary="Move an internal account", description="Move the internal account specified by the given id to a different directory.", responses={@ApiResponse(responseCode="204", description="Internal account moved")})
    public Response move(@PathParam(value="internalaccountid") long var1, @Valid MoveInternalAccount var3);
}

