/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.identitysource.IdentitySource;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Path(value="/identitysource")
@Supports(value={nl.topicus.cobra.restcontract.security.Operation.CREATE, nl.topicus.cobra.restcontract.security.Operation.READ, nl.topicus.cobra.restcontract.security.Operation.UPDATE, nl.topicus.cobra.restcontract.security.Operation.DELETE})
@ClassDefaultTag(value={"identitysource"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new identity sources", description="Creates one or more new identity sources and returns the newly created sources."), query=@CrudOperation(summary="Query for identity sources in Topicus KeyHub", description="Query for all identity sources in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single identity source by id", description="Returns the identity source identified by the id."), update=@CrudOperation(summary="Update an identity source", description="Updates the identity source identified by the id."), delete=@CrudOperation(summary="Delete an identity source", description="Permanently removes the identity source identified by the id. This cannot be undone."))
public interface IdentitySourceResource
extends KeyHubCrudRestResource<IdentitySource> {
    public static final String RESOURCE_PATH = "/identitysource";

    @POST
    @Path(value="{identitysourceid:\\d+}/sync")
    @Operation(summary="Trigger a full synchronization of an identity source", description="Perform a full synchronization of the identity source specified by the given id. The synchronization runs in the background.", responses={@ApiResponse(responseCode="204", description="Synchronization started")})
    public void sync(@PathParam(value="identitysourceid") long var1);
}

