/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CreateOnly;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.annotations.SupportsFiltering;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.LinkableWrapperWithCount;
import nl.topicus.keyhub.servicecontract.model.SegmentedLinkableWrapper;
import nl.topicus.keyhub.servicecontract.model.audit.GroupAudit;
import nl.topicus.keyhub.servicecontract.model.client.ClientApplication;
import nl.topicus.keyhub.servicecontract.model.client.OAuth2ClientPermissionWithClient;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectory;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectorySummary;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.group.GroupAccessInfo;
import nl.topicus.keyhub.servicecontract.model.group.GroupAccount;
import nl.topicus.keyhub.servicecontract.model.group.GroupAdminMail;
import nl.topicus.keyhub.servicecontract.model.group.GroupAuditingInfo;
import nl.topicus.keyhub.servicecontract.model.group.GroupClassificationUpdate;
import nl.topicus.keyhub.servicecontract.model.group.GroupClient;
import nl.topicus.keyhub.servicecontract.model.group.GroupGlobalRoleInfo;
import nl.topicus.keyhub.servicecontract.model.group.GroupInfo;
import nl.topicus.keyhub.servicecontract.model.group.GroupPrimer;
import nl.topicus.keyhub.servicecontract.model.group.GroupRequestStatus;
import nl.topicus.keyhub.servicecontract.model.group.GroupsAuditStats;
import nl.topicus.keyhub.servicecontract.model.group.ProvisioningGroup;
import nl.topicus.keyhub.servicecontract.model.mark.ItemMarkers;
import nl.topicus.keyhub.servicecontract.model.organization.OrganizationalUnit;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfile;
import nl.topicus.keyhub.servicecontract.model.provisioning.OwnedGroupOnSystemsWrapper;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystem;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccount;
import nl.topicus.keyhub.servicecontract.model.vault.Vault;
import nl.topicus.keyhub.servicecontract.model.webhook.Webhook;
import nl.topicus.keyhub.servicecontract.resources.GroupAccountResource;
import nl.topicus.keyhub.servicecontract.resources.GroupAuditResource;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;
import nl.topicus.keyhub.servicecontract.resources.VaultResource;

@Path(value="/group")
@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE})
@ClassDefaultTag(value={"group"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new groups", description="Creates one or more new groups and returns the newly created groups. It is required to specify the first admin via the admins additional object."), query=@CrudOperation(summary="Query for groups in Topicus KeyHub", description="Query for all groups in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single group by id", description="Returns the group identified by the id."), update=@CrudOperation(summary="Update a group", description="Updates the group identified by the id."))
public interface GroupResource
extends KeyHubCrudRestResource<Group> {
    public static final String RESOURCE_PATH = "/group";
    public static final AdditionalObjectKey<LinkableWrapper<GroupClient>> CLIENTS = new AdditionalObjectKey("clients");
    @CreateOnly
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<LinkableWrapper<OAuth2ClientPermissionWithClient>> CLIENT_PERMISSIONS = new AdditionalObjectKey("clientPermissions");
    public static final AdditionalObjectKey<LinkableWrapper<ClientApplication>> ADMINISTERED_APPS = new AdditionalObjectKey("administeredClients");
    public static final AdditionalObjectKey<LinkableWrapper<ProvisionedSystem>> ADMINISTERED_SYSTEMS = new AdditionalObjectKey("administeredSystems");
    public static final AdditionalObjectKey<LinkableWrapper<ProvisionedSystem>> CONTENT_ADMINISTERED_SYSTEMS = new AdditionalObjectKey("contentAdministeredSystems");
    public static final AdditionalObjectKey<LinkableWrapper<ServiceAccount>> ADMINISTERED_SERVICE_ACCOUNTS = new AdditionalObjectKey("serviceAccounts");
    public static final AdditionalObjectKey<LinkableWrapper<ClientApplication>> OWNED_APPS = new AdditionalObjectKey("ownedClients");
    public static final AdditionalObjectKey<LinkableWrapper<ProvisionedSystem>> OWNED_SYSTEMS = new AdditionalObjectKey("ownedSystems");
    public static final AdditionalObjectKey<Void> ONLY_LINKED_OWNED_GROUPS_ON_SYSTEMS = new AdditionalObjectKey("onlyLinkedGOS");
    public static final AdditionalObjectKey<OwnedGroupOnSystemsWrapper> OWNED_GROUPS_ON_SYSTEM = new AdditionalObjectKey("ownedGroupsOnSystem");
    public static final AdditionalObjectKey<LinkableWrapper<AccountDirectory>> OWNED_DIRECTORIES = new AdditionalObjectKey("ownedDirectories");
    public static final AdditionalObjectKey<LinkableWrapper<OrganizationalUnit>> OWNED_ORGANIZATIONAL_UNITS = new AdditionalObjectKey("ownedOrganizationalUnits");
    public static final AdditionalObjectKey<LinkableWrapper<AccessProfile>> OWNED_ACCESS_PROFILES = new AdditionalObjectKey("ownedAccessProfiles");
    public static final AdditionalObjectKey<LinkableWrapper<ProvisioningGroup>> SYSTEMS = new AdditionalObjectKey("systems");
    public static final AdditionalObjectKey<LinkableWrapper<Webhook>> WEBHOOKS = new AdditionalObjectKey("webhooks");
    public static final AdditionalObjectKey<GroupInfo> GROUPINFO = new AdditionalObjectKey("groupinfo");
    public static final AdditionalObjectKey<GroupRequestStatus> REQUEST_STATUS = new AdditionalObjectKey("requeststatus");
    public static final AdditionalObjectKey<Vault> VAULT = new AdditionalObjectKey("vault");
    public static final AdditionalObjectKey<GroupAccessInfo> GROUP_ACCESS_INFO = new AdditionalObjectKey("groupAccessInfo");
    @CreateOnly
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    @Deprecated(forRemoval=true, since="66")
    public static final AdditionalObjectKey<LinkableWrapper<GroupAccount>> ADMINS = new AdditionalObjectKey("admins");
    @CreateOnly
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<LinkableWrapper<GroupAccount>> ACCOUNTS = new AdditionalObjectKey("accounts");
    public static final AdditionalObjectKey<GroupAccount> MY_ACCOUNT = new AdditionalObjectKey("myaccount");
    public static final AdditionalObjectKey<GroupAccount> MY_DELEGATED_ACCOUNT = new AdditionalObjectKey("mydelegatedaccount");
    public static final AdditionalObjectKey<ItemMarkers> MARKERS = new AdditionalObjectKey("markers");
    public static final AdditionalObjectKey<GroupAuditingInfo> GROUP_AUDITING_INFO = new AdditionalObjectKey("groupauditinginfo");
    public static final AdditionalObjectKey<LinkableWrapper<GroupAudit>> RECENT_AUDITS = new AdditionalObjectKey("recentAudits");
    public static final AdditionalObjectKey<LinkableWrapper<AccountDirectorySummary>> HELPDESK = new AdditionalObjectKey("helpdesk");
    public static final AdditionalObjectKey<LinkableWrapperWithCount<Group>> AUTHORIZED_GROUPS = new AdditionalObjectKey("authorizedGroups");
    public static final AdditionalObjectKey<LinkableWrapper<GroupPrimer>> NESTED_GROUPS = new AdditionalObjectKey("nestedGroups");
    public static final AdditionalObjectKey<GroupGlobalRoleInfo> GLOBAL_ROLES = new AdditionalObjectKey("globalRoles");

    @Path(value="{groupid:\\d+}/account")
    public GroupAccountResource accounts(@PathParam(value="groupid") long var1);

    @Path(value="{groupid:\\d+}/audit")
    public GroupAuditResource audits(@PathParam(value="groupid") long var1);

    @Path(value="{groupid:\\d+}/vault")
    public VaultResource vault(@PathParam(value="groupid") long var1);

    @Path(value="{groupid:\\d+}/mail")
    @POST
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"group"}, summary="Send a mail to the managers of a group", description="Send a mail to the managers of the group identified by the id.", responses={@ApiResponse(responseCode="204", description="Mail sent")})
    public void mail(@PathParam(value="groupid") long var1, @Valid GroupAdminMail var3);

    @Path(value="{groupid:\\d+}/classification")
    @PUT
    @io.swagger.v3.oas.annotations.Operation(tags={"group"}, summary="Update the classification of a group", description="Update the classification of the group identified by the id.", responses={@ApiResponse(responseCode="204", description="Classification set")})
    public void writeClassification(@PathParam(value="groupid") long var1, GroupClassificationUpdate var3);

    @Path(value="{groupid:\\d+}/requestaudit")
    @POST
    @SecurityKey(value={KeyHubSecurityKeys.Auditor.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"group"}, summary="Request an audit from the managers of a group", description="Request an audit from the managers of the group identified by the id.", responses={@ApiResponse(responseCode="204", description="Audit requested")})
    public void requestAudit(@PathParam(value="groupid") long var1);

    @Path(value="segments")
    @GET
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"group"}, summary="Reads the segments of the groups", description="Returns the segments and counts of the groups. Groups will not be returned, but the counts will be filtered with the specified query parameters.")
    public SegmentedLinkableWrapper<Group> segments();

    @Path(value="auditstats")
    @GET
    @SecurityKey(value={KeyHubSecurityKeys.GroupDashboards.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Reads various group based counts and statistics", description="Returns the counts and statistics of groups within Topicus KeyHub.")
    public GroupsAuditStats getAuditStats();

    @POST
    @Path(value="export")
    @SecurityKey(value={KeyHubSecurityKeys.GroupDashboards.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Prepares an export of groups in CSV format", description="Prepares an export of groups using the filtering specified in the query parameters. The URI of the export can be found in the returned Location header. This URI is valid for 2 minutes after being generated.", responses={@ApiResponse(responseCode="202", description="Export prepared")})
    @SupportsFiltering(value=Group.class)
    public Response startExport();

    @POST
    @Path(value="account/export")
    @SecurityKey(value={KeyHubSecurityKeys.GroupDashboards.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Prepares an export of groupaccounts in CSV format", description="Prepares an export of groupaccounts using the filtering on groups specified in the query parameters. The URI of the export can be found in the returned Location header. This URI is valid for 2 minutes after being generated.", responses={@ApiResponse(responseCode="202", description="Export prepared")})
    @SupportsFiltering(value=Group.class)
    public Response startGroupAccountExport();
}

