/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.LinkableWrapperWithCount;
import nl.topicus.keyhub.servicecontract.model.group.ProvisioningGroup;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfileProvisioning;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupOnSystem;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccountPrimer;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Supports(value={nl.topicus.cobra.restcontract.security.Operation.CREATE, nl.topicus.cobra.restcontract.security.Operation.UPDATE, nl.topicus.cobra.restcontract.security.Operation.READ, nl.topicus.cobra.restcontract.security.Operation.DELETE})
@ClassDefaultTag(value={"provisioning"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new groups on systems", description="Creates one or more new groups on systems and returns the newly created groups on systems. The groups will also be provisioned to the targeted provisioned system. By default, for every group on system, a provisioning group will be created granting the owner access to the newly created group. It is also possible to specify the provisioning groups to be created via the 'provgroups' addionalObjects property."), query=@CrudOperation(summary="Query for groups on systems in Topicus KeyHub", description="Query for all groups on systems within a provisioned system in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single group on system by id", description="Returns the group on system identified by the id."), update=@CrudOperation(summary="Update a group on system", description="Updates the group on system identified by the id."), delete=@CrudOperation(summary="Delete a group on system", description="Deletes the group on system identified by the id. If 'system=true' is passed as query parameter, the group is also removed from the system."))
public interface GroupOnSystemResource
extends KeyHubCrudRestResource<GroupOnSystem> {
    public static final String SUB_RESOURCE_PATH = "group";
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<LinkableWrapperWithCount<ProvisioningGroup>> PROV_GROUPS = new AdditionalObjectKey("provgroups");
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<LinkableWrapperWithCount<ServiceAccountPrimer>> SERVICE_ACCOUNTS = new AdditionalObjectKey("serviceAccounts");
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<LinkableWrapperWithCount<AccessProfileProvisioning>> ACCESS_PROFILE_PROVISIONING = new AdditionalObjectKey("accessProfileProvisioning");

    @Override
    @Operation(parameters={@Parameter(name="system", in=ParameterIn.QUERY, schema=@Schema(type="boolean"), description="When false, the group will not be removed from the system.")})
    public Response delete(long var1);
}

