/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.audit.GroupAudit;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Supports(value={nl.topicus.cobra.restcontract.security.Operation.READ, nl.topicus.cobra.restcontract.security.Operation.UPDATE, nl.topicus.cobra.restcontract.security.Operation.CREATE})
@ClassDefaultTag(value={"group"})
@CrudOperations(create=@CrudOperation(summary="Create an audit for a group", description="Creates an audit for a group and returns the newly created memberships. Fetch a template for an audit via the 'new' resource."), query=@CrudOperation(summary="Query for audits for a group", description="Queries over all audits for a group. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single audit for a group", description="Returns a single audit for the group."), update=@CrudOperation(summary="Update an audit for a group", description="Updates the audit for a group identified by the id. Only audits in draft can be updated."))
public interface GroupAuditResource
extends KeyHubCrudRestResource<GroupAudit> {
    public static final String SUB_RESOURCE_PATH = "audit";
    public static final String AUDIT_ACCOUNT_PATH = "account";

    @GET
    @Path(value="new")
    @Operation(tags={"group"}, summary="Start a new audit or fetch a saved draft", description="Returns a template of a complete audit for the group or an earlier saved draft. The template or draft can then be filled in and posted to actually create the audit.")
    public GroupAudit getNewOrDraftAudit();

    @GET
    @Path(value="nextGroup")
    @Operation(tags={"group"}, summary="Retrieve the next group requiring an audit", description="Returns the next group that requires an audit or a 404 Not Found if there are none.Groups you directly manage are prioritised above groups you are delegated manager of.")
    public Response getNextGroup();
}

