/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.group.GroupAccount;
import nl.topicus.keyhub.servicecontract.model.group.GroupAccountNesting;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Supports(value={nl.topicus.cobra.restcontract.security.Operation.CREATE, nl.topicus.cobra.restcontract.security.Operation.READ, nl.topicus.cobra.restcontract.security.Operation.UPDATE, nl.topicus.cobra.restcontract.security.Operation.DELETE})
@ClassDefaultTag(value={"account", "group"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new memberships for a group", description="Creates one or more new memberships for a group and returns the newly created memberships."), query=@CrudOperation(summary="Query for memberships for a group", description="Queries over all members of a group. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single membership for a group", description="Returns the single membership for the group. This also contains information such as the rights and provisioning information."), update=@CrudOperation(summary="Update a memberships for a group", description="Updates the memberships for a group identified by the id."), delete=@CrudOperation(summary="Remove a membership from a group", description="Removes the specified membership, effectively removing the account from the group."))
public interface GroupAccountResource
extends KeyHubCrudRestResource<GroupAccount> {
    public static final String SUB_RESOURCE_PATH = "account";

    @PUT
    @Path(value="{accountid:\\d+}/nesting")
    @Operation(tags={"group"}, summary="Updates the nesting status of a group membership", description="Updates the nesting status of a group membership.", responses={@ApiResponse(responseCode="204", description="Nesting status updated")})
    public void updateNesting(@PathParam(value="accountid") long var1, @Valid GroupAccountNesting var3);

    @DELETE
    @Path(value="{accountid:\\d+}/activation")
    @Operation(tags={"group"}, summary="Revokes the permission to activate the group", description="Revokes the permission to activate the group.", responses={@ApiResponse(responseCode="204", description="Permission revoked")})
    public void revokeActivationPermission(@PathParam(value="accountid") long var1);
}

