/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.vault.DeletedVaultHolder;
import nl.topicus.keyhub.servicecontract.model.vault.DeletedVaultRecovery;
import nl.topicus.keyhub.servicecontract.model.vault.Vault;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;
import nl.topicus.keyhub.servicecontract.resources.VaultResource;

@Path(value="/deletedvaultholder")
@Supports(value={nl.topicus.cobra.restcontract.security.Operation.READ, nl.topicus.cobra.restcontract.security.Operation.DELETE})
@ClassDefaultTag(value={"vault"})
@CrudOperations(query=@CrudOperation(summary="Query for deleted vaults in Topicus KeyHub", description="Query for all deletes vaults in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single deleted vault by id", description="Returns the deleted vault identified by the id."), delete=@CrudOperation(summary="Permanently delete a deleted vault", description="Permanently removes the deleted vault identified by the id. This cannot be undone."))
public interface DeletedVaultHolderResource
extends KeyHubCrudRestResource<DeletedVaultHolder> {
    public static final String RESOURCE_PATH = "/deletedvaultholder";
    public static final AdditionalObjectKey<Vault> VAULT = new AdditionalObjectKey("vault");

    @Path(value="{vaultid:\\d+}/vault")
    public VaultResource vault(@PathParam(value="vaultid") long var1);

    @POST
    @Path(value="{vaultid:\\d+}/recover")
    @SecurityKey(value={KeyHubSecurityKeys.KeyHubAdmin.class})
    @Operation(summary="Recover a deleted vault", description="Recover a deleted vault, moving the records to a group or personal vault.", responses={@ApiResponse(responseCode="204", description="Vault recovered")})
    public Response recover(@PathParam(value="vaultid") long var1, @Valid DeletedVaultRecovery var3);
}

