/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.CobraSecurityKeys;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.BackendDeterminesDefault;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.ClientRestriction;
import nl.topicus.keyhub.servicecontract.annotations.CreateOnly;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.GeneratedSecret;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.LinkableWrapperWithCount;
import nl.topicus.keyhub.servicecontract.model.client.ClientApplication;
import nl.topicus.keyhub.servicecontract.model.client.OAuth2Client;
import nl.topicus.keyhub.servicecontract.model.client.OAuth2ClientAuthentication;
import nl.topicus.keyhub.servicecontract.model.client.OAuth2ClientVersionUsages;
import nl.topicus.keyhub.servicecontract.model.client.SubjectId;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.group.GroupClient;
import nl.topicus.keyhub.servicecontract.model.launchpad.SsoApplicationLaunchpadTile;
import nl.topicus.keyhub.servicecontract.model.organization.ClientApplicationOrganizationalUnit;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfileClient;
import nl.topicus.keyhub.servicecontract.model.vault.VaultUnlock;
import nl.topicus.keyhub.servicecontract.model.vault.VaultUnlockResponse;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;
import nl.topicus.keyhub.servicecontract.resources.OAuth2ClientPermissionResource;
import nl.topicus.keyhub.servicecontract.resources.VaultResource;

@Path(value="/client")
@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE, Operation.DELETE})
@ClassDefaultTag(value={"client"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new clients", description="Creates one or more new clients and returns the newly created clients."), query=@CrudOperation(summary="Query for clients in Topicus KeyHub", description="Query for all clients in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single client by id", description="Returns the client identified by the id."), update=@CrudOperation(summary="Update a client", description="Updates the client identified by the id."), delete=@CrudOperation(summary="Delete a client", description="Permanently removes the client identified by the id. This cannot be undone."))
public interface ClientResource
extends KeyHubCrudRestResource<ClientApplication> {
    public static final String AUTHENTICATOR_CLIENT_ID = "Topicus Authenticator";
    public static final String CONSOLE_CLIENT_ID = "4f86eb97-65a9-4621-8ca6-f1f14a6a58fa";
    public static final String APPLIANCE_MANAGER_ID = "90111b5c-4bcc-4ef9-9199-111abeca7686";
    public static final String BROWSER_EXTENSION_ID = "573abe51-0dc2-4293-bce9-599321164042";
    public static final String CLI_ID = "77ef8551-b8f2-46da-9932-1241e7997b0b";
    public static final String CONNECTORS_ID = "399ad754-922e-466c-8901-63835c367d64";
    public static final String MOBILE_APP_CLIENT_ID = "cca692b4-a491-493f-a081-117bcf59bcd2";
    public static final String RESET_VAULT = "RESETVAULT";
    public static final String RESOURCE_PATH = "/client";
    @BackendDeterminesDefault
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<GeneratedSecret> SECRET = new AdditionalObjectKey("secret");
    public static final AdditionalObjectKey<LinkableWrapper<Group>> GROUPS = new AdditionalObjectKey("groups");
    public static final AdditionalObjectKey<LinkableWrapper<ClientApplicationOrganizationalUnit>> ORGANIZATIONAL_UNITS = new AdditionalObjectKey("organizationalUnits");
    @CreateOnly
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<LinkableWrapperWithCount<GroupClient>> GROUP_CLIENTS = new AdditionalObjectKey("groupclients");
    @CreateOnly
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<LinkableWrapperWithCount<AccessProfileClient>> ACCESS_PROFILE_CLIENTS = new AdditionalObjectKey("accessprofileclients");
    public static final AdditionalObjectKey<Integer> VAULT_RECORD_COUNT = new AdditionalObjectKey("vaultRecordCount");
    @Schema(accessMode=Schema.AccessMode.READ_WRITE)
    public static final AdditionalObjectKey<SsoApplicationLaunchpadTile> LAUNCHPAD_TILE = new AdditionalObjectKey("tile");
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY)
    public static final AdditionalObjectKey<Boolean> DELETE_LAUNCHPAD_TILE = new AdditionalObjectKey("deleteTile");

    @GET
    @Path(value="me")
    @SecurityKey(value={KeyHubSecurityKeys.Profile.class})
    public OAuth2Client me();

    @POST
    @Path(value="me/secret")
    @SecurityKey(value={KeyHubSecurityKeys.Profile.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"client"}, summary="Rotate the secret for the current OAuth2 client", description="The given secret will be verified and a new secret generated and returned.", responses={@ApiResponse(responseCode="200", description="The new secret")})
    public GeneratedSecret rotateSecret(GeneratedSecret var1);

    @POST
    @Path(value="checksecret")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public Response checkClientSecret(@Valid OAuth2ClientAuthentication var1);

    @POST
    @Path(value="vault/unlock")
    @SecurityKey(value={KeyHubSecurityKeys.AccessVault.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"vault"}, summary="Unlocks the client's vault", description="Unlocks the vault of the authenticated client. Use the session password in the response via the topicus-Vault-session header to access secrets. The prefered way to unlock a vault is via the authentication by passing 'authVault=\"access\"' to the OAuth2 token endpoint.", responses={@ApiResponse(responseCode="200", description="Vault unlocked", content={@Content(schema=@Schema(implementation=VaultUnlockResponse.class))})})
    public Response unlockVault(@Valid VaultUnlock var1);

    @Path(value="{clientid:\\d+}/vault")
    public VaultResource vault(@PathParam(value="clientid") long var1);

    @Path(value="{clientid:\\d+}/permission")
    public OAuth2ClientPermissionResource permission(@PathParam(value="clientid") long var1);

    @GET
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    @ClientRestriction(allowed={"Topicus Authenticator"})
    @Path(value="subject/{clientid}/{subject}")
    public SubjectId subjectId(@PathParam(value="clientid") String var1, @PathParam(value="subject") String var2);

    @GET
    @Path(value="{clientid:\\d+}/versions")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa"})
    public OAuth2ClientVersionUsages versionUsages(@PathParam(value="clientid") long var1);

    @DELETE
    @Path(value="{clientid:\\d+}/versions")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa"})
    public Response clearVersionUsages(@PathParam(value="clientid") long var1);
}

