/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import jakarta.validation.Valid;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.ClientRestriction;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.certificate.Certificate;
import nl.topicus.keyhub.servicecontract.model.certificate.CertificateLocation;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Path(value="/certificate")
@Supports(value={Operation.READ, Operation.CREATE, Operation.UPDATE, Operation.DELETE})
@ClassDefaultTag(value={"miscellaneous"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new global trusted certificates", description="Creates one or more new global trusted certificates and returns the newly created certificates."), query=@CrudOperation(summary="Query for global trusted certificates in Topicus KeyHub", description="Query for all global trusted certificates in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single global trusted certificate by id", description="Returns the global trusted certificate identified by the id."), update=@CrudOperation(summary="Update a global trusted certificate", description="Updates the global trusted certificate identified by the id."), delete=@CrudOperation(summary="Delete a global trusted certificate", description="Permanently removes the global trusted certificate identified by the id. This cannot be undone."))
public interface CertificateResource
extends KeyHubCrudRestResource<Certificate> {
    public static final String RESOURCE_PATH = "/certificate";

    @Path(value="fetch")
    @POST
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "90111b5c-4bcc-4ef9-9199-111abeca7686"})
    public LinkableWrapper<Certificate> fetch(@Valid CertificateLocation var1);
}

