/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.annotations.SupportsFiltering;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.audit.AuditRecord;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Path(value="/audit")
@Supports(value={nl.topicus.cobra.restcontract.security.Operation.READ})
@ClassDefaultTag(value={"miscellaneous"})
@CrudOperations(query=@CrudOperation(summary="Query for audit records in Topicus KeyHub", description="Query for all audit records in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single audit record by id", description="Returns the audit record identified by the id."))
public interface AuditRecordResource
extends KeyHubCrudRestResource<AuditRecord> {
    public static final String RESOURCE_PATH = "/audit";

    @POST
    @Path(value="export")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @Operation(tags={"miscellaneous"}, summary="Prepares an export of audit records in CSV format", description="Prepares an export of audit records using the filtering specified in the query parameters. The URI of the export can be found in the returned Location header. This URI is valid for 2 minutes after being generated.", responses={@ApiResponse(responseCode="202", description="Export prepared")})
    @SupportsFiltering(value=AuditRecord.class)
    public Response startExport();
}

