/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.CobraSecurityKeys;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.ClientRestriction;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.annotations.SupportsFiltering;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.LinkableWrapperWithCount;
import nl.topicus.keyhub.servicecontract.model.auth.Account;
import nl.topicus.keyhub.servicecontract.model.auth.AccountActivation;
import nl.topicus.keyhub.servicecontract.model.auth.AccountBulkUpdate;
import nl.topicus.keyhub.servicecontract.model.auth.AccountChangeLocale;
import nl.topicus.keyhub.servicecontract.model.auth.AccountChangePassword;
import nl.topicus.keyhub.servicecontract.model.auth.AccountChangePublicKey;
import nl.topicus.keyhub.servicecontract.model.auth.AccountRecoveryStatus;
import nl.topicus.keyhub.servicecontract.model.auth.AccountSettings;
import nl.topicus.keyhub.servicecontract.model.auth.AccountStatus;
import nl.topicus.keyhub.servicecontract.model.auth.AccountsAuditStats;
import nl.topicus.keyhub.servicecontract.model.auth.AdditionalAuthentication;
import nl.topicus.keyhub.servicecontract.model.auth.LostOnResetSummary;
import nl.topicus.keyhub.servicecontract.model.auth.Mobile2FAResponse;
import nl.topicus.keyhub.servicecontract.model.auth.Mobile2FAVerificationStatus;
import nl.topicus.keyhub.servicecontract.model.auth.MobileRegistration;
import nl.topicus.keyhub.servicecontract.model.auth.StoredAccountAttributes;
import nl.topicus.keyhub.servicecontract.model.auth.StoredUserSession;
import nl.topicus.keyhub.servicecontract.model.auth.TotpOffsetChangeConfirmation;
import nl.topicus.keyhub.servicecontract.model.auth.TwoFactorAuthenticationMethod;
import nl.topicus.keyhub.servicecontract.model.auth.TwoFactorAuthenticationSetup;
import nl.topicus.keyhub.servicecontract.model.auth.UnregisteredAccount;
import nl.topicus.keyhub.servicecontract.model.auth.WebAuthnSetup;
import nl.topicus.keyhub.servicecontract.model.group.AccountGroup;
import nl.topicus.keyhub.servicecontract.model.notification.Notifications;
import nl.topicus.keyhub.servicecontract.model.provisioning.AccountProvisioningStatusReport;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisioningStatus;
import nl.topicus.keyhub.servicecontract.model.provisioning.TokenPassword;
import nl.topicus.keyhub.servicecontract.model.simple.Strings;
import nl.topicus.keyhub.servicecontract.model.vault.Vault;
import nl.topicus.keyhub.servicecontract.model.vault.VaultUnlock;
import nl.topicus.keyhub.servicecontract.model.vault.VaultUnlockAuthenticator;
import nl.topicus.keyhub.servicecontract.model.vault.VaultUnlockResponse;
import nl.topicus.keyhub.servicecontract.resources.AccountAttributeValueResource;
import nl.topicus.keyhub.servicecontract.resources.AccountGroupResource;
import nl.topicus.keyhub.servicecontract.resources.AccountOrganizationalUnitResource;
import nl.topicus.keyhub.servicecontract.resources.IdentityResource;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;
import nl.topicus.keyhub.servicecontract.resources.VaultResource;
import nl.topicus.keyhub.servicecontract.resources.WebAuthnKeyResource;

@Path(value="/account")
@Supports(value={Operation.READ, Operation.DELETE})
@ClassDefaultTag(value={"account"})
@CrudOperations(query=@CrudOperation(summary="Query for accounts in Topicus KeyHub", description="Query for all accounts in Topicus KeyHub. This will query over all directories and return both active and inactive accounts. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single account by id", description="Returns the account identified by the id."), delete=@CrudOperation(summary="Delete an account from Topicus KeyHub", description="Permanently removes the account. This cannot be undone."))
public interface AccountResource
extends KeyHubCrudRestResource<Account> {
    public static final String RESOURCE_PATH = "/account";
    public static final AdditionalObjectKey<LinkableWrapperWithCount<AccountGroup>> GROUPS = new AdditionalObjectKey("groups");
    public static final AdditionalObjectKey<Boolean> ACTIVE_SESSION = new AdditionalObjectKey("activeLogin");
    public static final AdditionalObjectKey<Vault> VAULT = new AdditionalObjectKey("vault");
    public static final AdditionalObjectKey<StoredAccountAttributes> STORED_ATTRIBUTES = new AdditionalObjectKey("storedAttributes");
    public static final AdditionalObjectKey<AccountRecoveryStatus> PENDING_RECOVERY_REQUESTS = new AdditionalObjectKey("pendingRecoveryRequests");
    public static final AdditionalObjectKey<AccountSettings> SETTINGS = new AdditionalObjectKey("settings");
    public static final String ADMIN_ACCOUNT_ID = "112a5df6-fcdb-4732-bc71-e741be5c1def";

    @GET
    @Path(value="me")
    @SecurityKey(value={KeyHubSecurityKeys.Profile.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"profile"}, summary="Current user", description="Returns the account of the currently authenticated user. The returned account will contain a complete list of all permissions of the account, restricted by the scope of the access token.", responses={@ApiResponse(responseCode="200", description="Authenticated user", content={@Content(schema=@Schema(implementation=Account.class))})})
    public Response me();

    @POST
    @Path(value="upgrade")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa"})
    public Response upgradeSecurityLevel(@Valid AdditionalAuthentication var1);

    @GET
    @Path(value="me/settings")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"profile"}, summary="Returns an overview of the settings selected by the current user.", description="Returns an overview of the settings selected by the current user.")
    public AccountSettings getSettings(@HeaderParam(value="topicus-Vault-session") String var1);

    @GET
    @Path(value="me/notifications")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"profile"}, summary="Returns a list of notifications for the user.", description="Returns the notifications to be displayed on the dashboard of the user. At most 50 notifications are returned.")
    public Notifications getNotifications(@QueryParam(value="requestMailKey") String var1, @QueryParam(value="requestsToRetainIds") Set<Long> var2, @QueryParam(value="lang") String var3);

    @POST
    @Path(value="me/password")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public void checkPassword(@Valid Strings var1);

    @PUT
    @Path(value="me/password")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public void updatePassword(@Valid AccountChangePassword var1, @QueryParam(value="persist") @DefaultValue(value="true") boolean var2);

    @POST
    @Path(value="me/repair")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public void repairSignatures();

    @GET
    @Path(value="me/settings/2fa")
    @SecurityKey(value={KeyHubSecurityKeys.SetupTwoFactor.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public TwoFactorAuthenticationSetup get2FASetup();

    @POST
    @Path(value="me/settings/2fa")
    @SecurityKey(value={KeyHubSecurityKeys.SetupTwoFactor.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public void set2FASetup(@Valid TwoFactorAuthenticationSetup var1);

    @DELETE
    @Path(value="me/settings/2fa")
    @SecurityKey(value={KeyHubSecurityKeys.SetupTwoFactor.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public void deleteTotp();

    @PUT
    @Path(value="me/settings/2fa")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public Response confirmTotpOffsetChange(@NotNull @Valid TotpOffsetChangeConfirmation var1);

    @GET
    @Path(value="me/settings/webauthn")
    @SecurityKey(value={KeyHubSecurityKeys.SetupTwoFactor.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public WebAuthnSetup getWebAuthnSetup();

    @POST
    @Path(value="me/settings/webauthn")
    @SecurityKey(value={KeyHubSecurityKeys.SetupTwoFactor.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public void setWebAuthnSetup(@Valid WebAuthnSetup var1);

    @GET
    @Path(value="2fa/request")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public AdditionalAuthentication getTwoFactorAuthenticateRequest(@QueryParam(value="subject") String var1, @QueryParam(value="method") TwoFactorAuthenticationMethod var2, @QueryParam(value="clearRequest") String var3);

    @POST
    @Path(value="me/settings/sshkey")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public void setSshPublicKey(@Valid AccountChangePublicKey var1);

    @POST
    @Path(value="me/settings/locale")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"profile"}, summary="Updates the locale for the current user", description="Updates the locale for the current user.", responses={@ApiResponse(responseCode="204", description="Locale updated")})
    public void setLocale(@Valid AccountChangeLocale var1);

    @GET
    @Path(value="me/lostonreset")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public LostOnResetSummary getLostOnResetSummary();

    @POST
    @Path(value="mobile/{id}")
    @Hidden
    public void registerMobile(@PathParam(value="id") String var1, @Valid MobileRegistration var2);

    @PUT
    @Path(value="mobile/{id}")
    @Hidden
    public void mobile2FA(@PathParam(value="id") String var1, @Valid Mobile2FAResponse var2);

    @GET
    @Path(value="mobile/{id}")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public Response getMobileRegistrationProgress(@PathParam(value="id") String var1, @QueryParam(value="secretHash") String var2);

    @GET
    @Path(value="2fa/{token}")
    @ClientRestriction(allowed={"4f86eb97-65a9-4621-8ca6-f1f14a6a58fa", "Topicus Authenticator"})
    public Mobile2FAVerificationStatus read2FAStatus(@PathParam(value="token") String var1);

    @POST
    @Path(value="vault/unlock")
    @SecurityKey(value={KeyHubSecurityKeys.AccessVault.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"vault"}, summary="Unlocks the user's vault", description="Unlocks the vault of the authenticated user. Use the session password in the response via the topicus-Vault-session header to access secrets. The prefered way to unlock a vault is via the authentication by passing 'authVault=\"access\"' to the OAuth2 authorization endpoint.", responses={@ApiResponse(responseCode="200", description="Vault unlocked", content={@Content(schema=@Schema(implementation=VaultUnlockResponse.class))})})
    public Response unlockVault(@Valid VaultUnlock var1);

    @POST
    @Path(value="vault/unlockauthenticator")
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    @ClientRestriction(allowed={"Topicus Authenticator"})
    public Response unlockVaultAuthenticator(@Valid VaultUnlockAuthenticator var1);

    @POST
    @Path(value="vault/check")
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    @ClientRestriction(allowed={"Topicus Authenticator"})
    public Response checkUnlockedVault(@Valid VaultUnlockAuthenticator var1);

    @POST
    @Path(value="register")
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    @ClientRestriction(allowed={"Topicus Authenticator"})
    public Response register(@Valid UnregisteredAccount var1);

    @GET
    @Path(value="session")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"account"}, summary="Returns a list of active sessions for the user", description="Returns a list of active sessions for the current user.")
    public LinkableWrapper<StoredUserSession> userSessions();

    @DELETE
    @Path(value="session/{sessionId}")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"account"}, summary="Ends a session", description="Ends the given session for the current user. Access tokens issued for the session will be revoked.", responses={@ApiResponse(responseCode="204", description="Session ended")})
    public void deleteUserSession(@PathParam(value="sessionId") String var1);

    @DELETE
    @Path(value="session")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"account"}, summary="Ends all sessions except the current", description="Ends all sessions for the current user except the current session. Access tokens issued for these sessions will be revoked.", responses={@ApiResponse(responseCode="204", description="All sessions ended")})
    public void deleteOtherSessions();

    @PUT
    @Path(value="{accountid:\\d+}/status")
    @io.swagger.v3.oas.annotations.Operation(tags={"account"}, summary="Updates one or more status toggles for the account", description="Updates one or more status toggles for the account. Only the values set will be updated on the account.", responses={@ApiResponse(responseCode="204", description="Account updated")})
    public void updateAccountStatus(@PathParam(value="accountid") long var1, @Valid AccountStatus var3);

    @PUT
    @Path(value="status/bulk")
    @SecurityKey(value={KeyHubSecurityKeys.KeyHubAdmin.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"account"}, summary="Updates multiple accounts", description="Updates multiple accounts. The given accounts will be updated according to the selected action, for example, have their license role set to the given license role, provided this matches the current license's conditions.", responses={@ApiResponse(responseCode="204", description="Accounts updated")})
    @SupportsFiltering(value=Account.class)
    public void updateBulk(@Valid AccountBulkUpdate var1);

    @POST
    @Path(value="{accountid:\\d+}/validate")
    @SecurityKey(value={KeyHubSecurityKeys.KeyHubAdmin.class, KeyHubSecurityKeys.Helpdesk.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"account"}, summary="Checks the validity of the account in its directory", description="Checks the validity of the account in its directory and returns the updated status.")
    public Account validate(@PathParam(value="accountid") long var1);

    @POST
    @Path(value="provisioning/rotatepwd")
    @SecurityKey(value={KeyHubSecurityKeys.ReadTokenPassword.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"provisioning"}, summary="Rotates the user's rotating password", description="Manually rotates the user's rotating password. This is normally done once a day automatically.")
    public AccountProvisioningStatusReport rotateTokenPassword();

    @GET
    @Path(value="provisioning/tokenpwd")
    @SecurityKey(value={KeyHubSecurityKeys.ReadTokenPassword.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"provisioning"}, summary="Reads the user's rotating password", description="Returns the user's rotating password as it is set for the current user.")
    public TokenPassword getTokenPassword();

    @GET
    @Path(value="provisioning")
    @io.swagger.v3.oas.annotations.Operation(tags={"provisioning"}, summary="Reads the user's provisioning status", description="Returns the status of provisioning for the current user. The groups are filtered by the specified filter or group UUID.")
    public ProvisioningStatus provisioningStatus(@QueryParam(value="filter") String var1, @QueryParam(value="groupUuid") String var2, @QueryParam(value="loadAll") @DefaultValue(value="false") boolean var3);

    @PUT
    @Path(value="provisioning")
    @SecurityKey(value={KeyHubSecurityKeys.FeatureGroupActivation.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"provisioning"}, summary="Updates the user's provisioning", description="Updates the provisioning for the current user. This updates the end time for the given groups. If 'ignoreErrors' is set, errors do not cause the update to abort if errors are detected. To enable groups with auditing enabled the reason query parameter is required.", responses={@ApiResponse(responseCode="200", description="Status updated", content={@Content(schema=@Schema(implementation=ProvisioningStatus.class))})})
    public Response updateProvisioningStatus(@Valid ProvisioningStatus var1, @QueryParam(value="reason") String var2);

    @GET
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    @ClientRestriction(allowed={"Topicus Authenticator"})
    @Path(value="activation/{code}")
    public AccountActivation getActivation(@PathParam(value="code") String var1);

    @PUT
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    @ClientRestriction(allowed={"Topicus Authenticator"})
    @Path(value="activation/{code}")
    public Response activate(@PathParam(value="code") String var1, @Valid AccountActivation var2);

    @Path(value="auditstats")
    @GET
    @SecurityKey(value={KeyHubSecurityKeys.Auditor.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Reads various account based counts and statistics", description="Returns the counts and statistics of accounts within Topicus KeyHub.")
    public AccountsAuditStats getAuditStats();

    @Path(value="{accountid:\\d+}/group")
    public AccountGroupResource groups(@PathParam(value="accountid") long var1);

    @Path(value="{accountid:\\d+}/organizationalunit")
    public AccountOrganizationalUnitResource organizationalUnits(@PathParam(value="accountid") long var1);

    @Path(value="{accountid:\\d+}/vault")
    public VaultResource vault(@PathParam(value="accountid") long var1);

    @Path(value="{accountid:\\d+}/webauthnkey")
    public WebAuthnKeyResource webAuthnKey(@PathParam(value="accountid") long var1);

    @Path(value="{accountid:\\d+}/identity")
    public IdentityResource identity(@PathParam(value="accountid") long var1);

    @Path(value="{accountid:\\d+}/attributevalue")
    public AccountAttributeValueResource attribute(@PathParam(value="accountid") long var1);

    @POST
    @Path(value="export")
    @SecurityKey(value={KeyHubSecurityKeys.Auditor.class})
    @io.swagger.v3.oas.annotations.Operation(tags={"miscellaneous"}, summary="Prepares an export of accounts in CSV format", description="Prepares an export of accounts using the filtering specified in the query parameters. The URI of the export can be found in the returned Location header. This URI is valid for 2 minutes after being generated.", responses={@ApiResponse(responseCode="202", description="Export prepared")})
    @SupportsFiltering(value=Account.class)
    public Response startExport();
}

