/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.Valid;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.group.AccountGroup;
import nl.topicus.keyhub.servicecontract.model.group.GroupAccountStatus;
import nl.topicus.keyhub.servicecontract.model.vault.Vault;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Supports(value={nl.topicus.cobra.restcontract.security.Operation.READ, nl.topicus.cobra.restcontract.security.Operation.DELETE})
@ClassDefaultTag(value={"account", "group"})
@CrudOperations(query=@CrudOperation(summary="Query for group memberships for an account", description="Queries over all groups the account is member of. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single group membership for an account", description="Returns the single group membership for the account. This also contains information such as the rights and provisioning information."), delete=@CrudOperation(summary="Remove a group membership from an account", description="Removes the specified group membership, effectively removing the account from the group."))
public interface AccountGroupResource
extends KeyHubCrudRestResource<AccountGroup> {
    public static final String SUB_RESOURCE_PATH = "group";
    public static final AdditionalObjectKey<Vault> VAULT = new AdditionalObjectKey("vault");

    @PUT
    @Path(value="{groupid:\\d+}/status")
    @SecurityKey(value={KeyHubSecurityKeys.ManageAccount.class})
    @Operation(tags={"profile"}, summary="Update group membership status", description="Updates the display settings for the group membership for the users own account. The group can be hidden from the dashboard or placed in a folder.", responses={@ApiResponse(responseCode="204", description="No content", content={})})
    public void updateStatus(@PathParam(value="groupid") long var1, @Valid GroupAccountStatus var3);
}

