/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.CobraSecurityKeys;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.ClientRestriction;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectory;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectoryStatusReport;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectorySummary;
import nl.topicus.keyhub.servicecontract.model.mark.ItemMarkers;
import nl.topicus.keyhub.servicecontract.resources.InternalAccountResource;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Path(value="/directory")
@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE, Operation.DELETE})
@ClassDefaultTag(value={"account"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new directories", description="Creates one or more new directories and returns the newly created directories."), query=@CrudOperation(summary="Query for directories in Topicus KeyHub", description="Query for all directories in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single directory by id", description="Returns the directory identified by the id."), update=@CrudOperation(summary="Update a directory", description="Updates the directory identified by the id."), delete=@CrudOperation(summary="Delete a directory from Topicus KeyHub", description="Permanently removes the directory. This cannot be undone."))
public interface AccountDirectoryResource
extends KeyHubCrudRestResource<AccountDirectory> {
    public static final String RESOURCE_PATH = "/directory";
    public static final AdditionalObjectKey<AccountDirectoryStatusReport> STATUS = new AdditionalObjectKey("status");
    public static final AdditionalObjectKey<ItemMarkers> MARKERS = new AdditionalObjectKey("markers");

    @Path(value="summary")
    @GET
    @SecurityKey(value={CobraSecurityKeys.Authenticator.class})
    @ClientRestriction(allowed={"Topicus Authenticator"})
    public LinkableWrapper<AccountDirectorySummary> getSummaries(@QueryParam(value="directory") String var1);

    @Path(value="{directoryid:\\d+}/internalaccount")
    public InternalAccountResource internalAccounts(@PathParam(value="directoryid") long var1);
}

