/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import nl.topicus.cobra.restcontract.annotation.SecurityKey;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.KeyHubSecurityKeys;
import nl.topicus.keyhub.servicecontract.model.identity.AccountAttributeValue;
import nl.topicus.keyhub.servicecontract.model.identity.AccountAttributeValueSelection;
import nl.topicus.keyhub.servicecontract.model.identity.AccountAttributeValueUpdate;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Supports(value={nl.topicus.cobra.restcontract.security.Operation.READ})
@ClassDefaultTag(value={"iga"})
@CrudOperations(query=@CrudOperation(summary="Query for account attribute values", description="Query for account attribute values for a specific account. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single account attribute value by id", description="Returns the account attribute value identified by the id."))
public interface AccountAttributeValueResource
extends KeyHubCrudRestResource<AccountAttributeValue> {
    public static final String SUB_RESOURCE_PATH = "attributevalue";
    public static final AdditionalObjectKey<AccountAttributeValue> PREVIOUS = new AdditionalObjectKey("previous");
    public static final AdditionalObjectKey<AccountAttributeValueSelection> SELECTION = new AdditionalObjectKey("selection");

    @POST
    @Path(value="override")
    @SecurityKey(value={KeyHubSecurityKeys.GroupAdmin.class})
    @Operation(tags={"iga"}, summary="Manually override an account attribute value", description="Manually override the value for an account attribute. A null value will clear the override.", responses={@ApiResponse(responseCode="204", description="Value set")})
    public void setOverride(AccountAttributeValueUpdate var1);
}

