/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.resources;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import nl.topicus.cobra.restcontract.annotation.Supports;
import nl.topicus.cobra.restcontract.model.AdditionalObjectKey;
import nl.topicus.cobra.restcontract.model.LinkableWrapper;
import nl.topicus.cobra.restcontract.security.Operation;
import nl.topicus.keyhub.servicecontract.annotations.ClassDefaultTag;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperation;
import nl.topicus.keyhub.servicecontract.annotations.CrudOperations;
import nl.topicus.keyhub.servicecontract.model.identity.AccountAttributeRule;
import nl.topicus.keyhub.servicecontract.model.identity.AccountAttributeUpdateOperation;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfile;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfileAccountWithAttributes;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfileClient;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfileGroup;
import nl.topicus.keyhub.servicecontract.model.profile.AccessProfileProvisioning;
import nl.topicus.keyhub.servicecontract.resources.AccessProfileAccountResource;
import nl.topicus.keyhub.servicecontract.resources.AccountAttributeRuleResource;
import nl.topicus.keyhub.servicecontract.resources.KeyHubCrudRestResource;

@Path(value="/profile")
@Supports(value={Operation.CREATE, Operation.READ, Operation.UPDATE})
@ClassDefaultTag(value={"iga"})
@CrudOperations(create=@CrudOperation(summary="Creates one or more new access profiles", description="Creates one or more new access profiles and returns the newly created access profiles."), query=@CrudOperation(summary="Query for access profiles in Topicus KeyHub", description="Query for all access profiles in Topicus KeyHub. The various query parameters can be used to filter the response."), read=@CrudOperation(summary="Read a single access profile by id", description="Returns the access profile identified by the id."), update=@CrudOperation(summary="Update an access profile", description="Updates the access profile identified by the id."))
public interface AccessProfileResource
extends KeyHubCrudRestResource<AccessProfile> {
    public static final String RESOURCE_PATH = "/profile";
    public static final AdditionalObjectKey<LinkableWrapper<AccessProfileAccountWithAttributes>> ACCOUNTS_WITH_ATTRIBUTES = new AdditionalObjectKey("accountsWithAttributes");
    public static final AdditionalObjectKey<LinkableWrapper<AccessProfileProvisioning>> PROVISIONING = new AdditionalObjectKey("provisioning");
    public static final AdditionalObjectKey<LinkableWrapper<AccessProfileClient>> CLIENTS = new AdditionalObjectKey("clients");
    public static final AdditionalObjectKey<LinkableWrapper<AccessProfileGroup>> GROUPS = new AdditionalObjectKey("groups");
    public static final AdditionalObjectKey<LinkableWrapper<AccountAttributeRule>> ATTRIBUTE_RULES = new AdditionalObjectKey("attributeRules");

    @POST
    @Path(value="{accessprofileid:\\d+}/attributes/sync")
    public void syncAttributes(@PathParam(value="accessprofileid") long var1, @QueryParam(value="account") Long var3, @QueryParam(value="operation") @DefaultValue(value="SYNC_ONLY") AccountAttributeUpdateOperation var4);

    @Path(value="{accessprofileid:\\d+}/account")
    public AccessProfileAccountResource accounts(@PathParam(value="accessprofileid") long var1);

    @Path(value="{accessprofileid:\\d+}/attributerule")
    public AccountAttributeRuleResource attributeRules(@PathParam(value="accessprofileid") long var1);
}

