/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.webhook;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import nl.topicus.cobra.restcontract.annotation.ExcludeFromMapping;
import nl.topicus.cobra.restcontract.annotation.OnResource;
import nl.topicus.cobra.restcontract.annotation.WriteScope;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.keyhub.servicecontract.annotations.CertificateOnly;
import nl.topicus.keyhub.servicecontract.annotations.Immutable;
import nl.topicus.keyhub.servicecontract.annotations.Sensitive;
import nl.topicus.keyhub.servicecontract.model.CertificateHolder;
import nl.topicus.keyhub.servicecontract.model.HttpAuthenticationScheme;
import nl.topicus.keyhub.servicecontract.model.TLSLevel;
import nl.topicus.keyhub.servicecontract.model.audit.AuditRecordType;
import nl.topicus.keyhub.servicecontract.model.auth.AccountPrimer;
import nl.topicus.keyhub.servicecontract.model.certificate.CertificatePrimer;
import nl.topicus.keyhub.servicecontract.model.client.ClientApplicationPrimer;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectoryPrimer;
import nl.topicus.keyhub.servicecontract.model.group.GroupPrimer;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystemPrimer;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@OnResource(value="/webhook")
@WriteScope(value={Webhook.class})
public class Webhook
extends Linkable
implements CertificateHolder {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private boolean active = true;
    @XmlElement
    @Size(max=36)
    @Immutable
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private @Size(max=36) String uuid;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String name;
    @XmlElement
    @Size(max=512)
    @NotBlank
    private @Size(max=512) @NotBlank String url;
    @XmlElement
    @NotNull
    private TLSLevel tls = TLSLevel.SECURE;
    @XmlElement
    @CertificateOnly
    @ExcludeFromMapping
    private CertificatePrimer trustedCertificate;
    @XmlElement
    @ExcludeFromMapping
    private CertificatePrimer clientCertificate;
    @XmlElement
    private HttpAuthenticationScheme authenticationScheme = HttpAuthenticationScheme.NONE;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String basicAuthUsername;
    @XmlElement
    @Sensitive
    private String basicAuthPassword;
    @XmlElement
    @Sensitive
    private String bearerToken;
    @XmlElement
    @Size(max=64)
    private @Size(max=64) String customHeaderName;
    @XmlElement
    @Sensitive
    private String customHeaderValue;
    @XmlElement
    private boolean verbosePayloads;
    @XmlElement
    private GroupPrimer group;
    @XmlElement
    private ClientApplicationPrimer client;
    @XmlElement
    private AccountDirectoryPrimer directory;
    @XmlElement
    private ProvisionedSystemPrimer system;
    @XmlElement
    private AccountPrimer account;
    @XmlElement
    private boolean allTypes;
    @XmlElementWrapper(name="types")
    @XmlElement(name="type")
    private List<AuditRecordType> types = new ArrayList<AuditRecordType>();

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public TLSLevel getTls() {
        return this.tls;
    }

    @Override
    public void setTls(TLSLevel tls) {
        this.tls = tls;
    }

    public boolean isVerbosePayloads() {
        return this.verbosePayloads;
    }

    public void setVerbosePayloads(boolean verbosePayloads) {
        this.verbosePayloads = verbosePayloads;
    }

    public GroupPrimer getGroup() {
        return this.group;
    }

    public void setGroup(GroupPrimer group) {
        this.group = group;
    }

    public ClientApplicationPrimer getClient() {
        return this.client;
    }

    public void setClient(ClientApplicationPrimer client) {
        this.client = client;
    }

    public AccountDirectoryPrimer getDirectory() {
        return this.directory;
    }

    public void setDirectory(AccountDirectoryPrimer directory) {
        this.directory = directory;
    }

    public ProvisionedSystemPrimer getSystem() {
        return this.system;
    }

    public void setSystem(ProvisionedSystemPrimer system) {
        this.system = system;
    }

    public AccountPrimer getAccount() {
        return this.account;
    }

    public void setAccount(AccountPrimer account) {
        this.account = account;
    }

    public boolean isAllTypes() {
        return this.allTypes;
    }

    public void setAllTypes(boolean allTypes) {
        this.allTypes = allTypes;
    }

    public List<AuditRecordType> getTypes() {
        return this.types;
    }

    public void setTypes(List<AuditRecordType> types) {
        this.types = types;
    }

    @Override
    public CertificatePrimer getTrustedCertificate() {
        return this.trustedCertificate;
    }

    @Override
    public void setTrustedCertificate(CertificatePrimer trustedCertificate) {
        this.trustedCertificate = trustedCertificate;
    }

    @Override
    public CertificatePrimer getFailoverTrustedCertificate() {
        return null;
    }

    @Override
    public void setFailoverTrustedCertificate(CertificatePrimer failoverTrustedCertificate) {
    }

    @Override
    public CertificatePrimer getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public void setClientCertificate(CertificatePrimer clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    public HttpAuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public void setAuthenticationScheme(HttpAuthenticationScheme authenticationScheme) {
        this.authenticationScheme = authenticationScheme;
    }

    public String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    public void setBasicAuthUsername(String basicAuthUsername) {
        this.basicAuthUsername = basicAuthUsername;
    }

    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    public void setBasicAuthPassword(String basicAuthPassword) {
        this.basicAuthPassword = basicAuthPassword;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public String getCustomHeaderName() {
        return this.customHeaderName;
    }

    public void setCustomHeaderName(String customHeaderName) {
        this.customHeaderName = customHeaderName;
    }

    public String getCustomHeaderValue() {
        return this.customHeaderValue;
    }

    public void setCustomHeaderValue(String customHeaderValue) {
        this.customHeaderValue = customHeaderValue;
    }

    @Override
    public String toOmschrijving() {
        return this.getName();
    }
}

