/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.vault;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import nl.topicus.cobra.restcontract.model.NonLinkable;
import nl.topicus.keyhub.servicecontract.annotations.Sensitive;
import nl.topicus.keyhub.servicecontract.model.vault.VaultSecretType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VaultRecordSecrets
extends NonLinkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @Sensitive
    private String password;
    @XmlElement
    @Sensitive
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private String totp;
    @XmlElement
    @Sensitive
    @Pattern(regexp="^$|[A-Z0-9\\s]{4,}", flags={Pattern.Flag.CASE_INSENSITIVE})
    @Schema(accessMode=Schema.AccessMode.WRITE_ONLY)
    private @Pattern(regexp="^$|[A-Z0-9\\s]{4,}", flags={Pattern.Flag.CASE_INSENSITIVE}) String totpKey;
    @XmlElement
    @Sensitive
    private String file;
    @XmlElement
    @Sensitive
    private String comment;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTotp() {
        return this.totp;
    }

    public void setTotp(String totp) {
        this.totp = totp;
    }

    public boolean isWriteTotp() {
        return this.totpKey != null;
    }

    public String getTotpKey() {
        return this.totpKey;
    }

    public void setTotpKey(String totpKey) {
        this.totpKey = totpKey;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String get(VaultSecretType type) {
        switch (type) {
            case PASSWORD: {
                return this.getPassword();
            }
            case TOTP: {
                return this.getTotp();
            }
            case FILE: {
                return this.getFile();
            }
            case COMMENT: {
                return this.getComment();
            }
        }
        throw new IllegalStateException();
    }

    public void set(VaultSecretType type, String secret) {
        switch (type) {
            case PASSWORD: {
                this.setPassword(secret);
                return;
            }
            case TOTP: {
                this.setTotp(secret);
                return;
            }
            case FILE: {
                this.setFile(secret);
                return;
            }
            case COMMENT: {
                this.setComment(secret);
                return;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSetForReading() {
        return this.getPassword() != null && !this.getPassword().isEmpty() || this.getTotp() != null && !this.getTotp().isEmpty() || this.getFile() != null && !this.getFile().isEmpty() || this.getComment() != null && !this.getComment().isEmpty();
    }

    public boolean isSetForWriting() {
        return this.getPassword() != null && !this.getPassword().isEmpty() || this.getTotpKey() != null && !this.getTotpKey().isEmpty() || this.getFile() != null && !this.getFile().isEmpty() || this.getComment() != null && !this.getComment().isEmpty();
    }
}

