/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.vault;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Instant;
import nl.topicus.cobra.restcontract.annotation.IUnderResolver;
import nl.topicus.cobra.restcontract.annotation.OnResource;
import nl.topicus.cobra.restcontract.annotation.PrimerFor;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.keyhub.servicecontract.annotations.Immutable;
import nl.topicus.keyhub.servicecontract.model.vault.Vault;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordColor;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@OnResource(under=Vault.class, value="record", underResolver=IUnderResolver.UnderResolverType.PropertyUnderResolver)
@PrimerFor(value=VaultRecord.class)
public class VaultRecordPrimer
extends Linkable
implements Comparable<VaultRecordPrimer> {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @Size(max=36)
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    @Immutable
    private @Size(max=36) String uuid;
    @XmlElement
    @Size(max=255)
    @NotBlank
    private @Size(max=255) @NotBlank String name;
    @XmlElement
    @NotNull
    private VaultRecordColor color = VaultRecordColor.NONE;
    @XmlElement
    @Immutable
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private Instant shareEndTime;

    public VaultRecordPrimer() {
    }

    public VaultRecordPrimer(VaultRecordPrimer record) {
        if (record.self() != null) {
            this.setLink(record.self());
        }
        this.setUuid(record.getUuid());
        this.setName(record.getName());
        this.setColor(record.getColor());
        this.setShareEndTime(record.getShareEndTime());
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VaultRecordColor getColor() {
        return this.color;
    }

    public void setColor(VaultRecordColor color) {
        this.color = color;
    }

    public Instant getShareEndTime() {
        return this.shareEndTime;
    }

    public void setShareEndTime(Instant shareEndTime) {
        this.shareEndTime = shareEndTime;
    }

    @Override
    public int compareTo(VaultRecordPrimer o) {
        int colorDiff = Integer.compare(this.getColor().index(), o.getColor().index());
        if (colorDiff != 0) {
            return colorDiff;
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    @Override
    public String toOmschrijving() {
        return this.getName();
    }
}

