/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.vault;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.LocalDate;
import java.util.Set;
import nl.topicus.cobra.restcontract.annotation.WriteScope;
import nl.topicus.keyhub.servicecontract.annotations.Immutable;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordExpiryStatus;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordPrimer;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecordWarningPeriod;
import nl.topicus.keyhub.servicecontract.model.vault.VaultSecretType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@WriteScope(value={VaultRecord.class})
public class VaultRecord
extends VaultRecordPrimer {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String url;
    @XmlElement
    private String additionalURLs;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String username;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String filename;
    @XmlElement(name="type")
    @XmlElementWrapper(name="types")
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private Set<VaultSecretType> types;
    @XmlElement
    private LocalDate endDate;
    @XmlElement
    private VaultRecordWarningPeriod warningPeriod;
    @XmlElement
    @Immutable
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean derived;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAdditionalURLs() {
        return this.additionalURLs;
    }

    public void setAdditionalURLs(String additionalURLs) {
        this.additionalURLs = additionalURLs;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Set<VaultSecretType> getTypes() {
        return this.types;
    }

    public void setTypes(Set<VaultSecretType> types) {
        this.types = types;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public VaultRecordWarningPeriod getWarningPeriod() {
        return this.warningPeriod;
    }

    public void setWarningPeriod(VaultRecordWarningPeriod warningPeriod) {
        this.warningPeriod = warningPeriod;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public VaultRecordExpiryStatus getExpiryStatus() {
        if (this.endDate != null && this.warningPeriod != VaultRecordWarningPeriod.NEVER) {
            if (!this.endDate.isAfter(LocalDate.now())) {
                return VaultRecordExpiryStatus.EXPIRED;
            }
            if (this.warningPeriod != null && !this.endDate.isAfter(LocalDate.now().plus(this.warningPeriod.getPeriod()))) {
                return VaultRecordExpiryStatus.WARN;
            }
        }
        return VaultRecordExpiryStatus.OK;
    }
}

