/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.serviceaccount;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import nl.topicus.cobra.restcontract.annotation.Embeds;
import nl.topicus.cobra.restcontract.annotation.OnResource;
import nl.topicus.cobra.restcontract.annotation.PrimerFor;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.keyhub.servicecontract.annotations.CreateOnly;
import nl.topicus.keyhub.servicecontract.annotations.Immutable;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystemPrimer;
import nl.topicus.keyhub.servicecontract.model.serviceaccount.ServiceAccount;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@OnResource(value="/serviceaccount")
@PrimerFor(value=ServiceAccount.class)
@Embeds(value={ProvisionedSystemPrimer.class})
public class ServiceAccountPrimer
extends Linkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private boolean active;
    @XmlElement
    @Size(max=36)
    @Immutable
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private @Size(max=36) String uuid;
    @XmlElement
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @XmlElement
    @NotBlank
    @Size(max=255)
    @Immutable
    @CreateOnly
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private @NotBlank @Size(max=255) String username;
    @XmlElement
    @NotNull
    @CreateOnly
    @Immutable
    private ProvisionedSystemPrimer system;

    public ServiceAccountPrimer() {
    }

    public ServiceAccountPrimer(ServiceAccountPrimer account) {
        this.setLink(account.self());
        this.setActive(account.isActive());
        this.setName(account.getName());
        this.setUsername(account.getUsername());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ProvisionedSystemPrimer getSystem() {
        return this.system;
    }

    public void setSystem(ProvisionedSystemPrimer system) {
        this.system = system;
    }

    @Override
    public String toOmschrijving() {
        return this.getName();
    }
}

