/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.request;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import nl.topicus.cobra.restcontract.model.NonLinkable;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequestReportChange;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequestReportChangeDetails;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequestReportConclusion;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequestReportError;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequestReportErrorDetails;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequestReportObjectChangeDetails;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ModificationRequestReport
extends NonLinkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private ModificationRequestReportConclusion conclusion;
    @XmlElementWrapper(name="errorDetails")
    @XmlElement(name="errorDetail")
    private List<ModificationRequestReportErrorDetails> errorDetails = new ArrayList<ModificationRequestReportErrorDetails>();
    @XmlElementWrapper(name="changeDetails")
    @XmlElement(name="changeDetail")
    private List<ModificationRequestReportObjectChangeDetails> changeDetails = new ArrayList<ModificationRequestReportObjectChangeDetails>();

    public ModificationRequestReport() {
        this.conclusion = ModificationRequestReportConclusion.OK;
    }

    public void error(ModificationRequestReportError error, String name) {
        this.error(error, List.of(name));
    }

    public void error(ModificationRequestReportError error, List<String> names) {
        this.conclusion = ModificationRequestReportConclusion.CANNOT_BE_EXECUTED;
        this.getErrorDetails().stream().filter(detail -> detail.getError() == error).findAny().orElseGet(() -> {
            ModificationRequestReportErrorDetails ret = new ModificationRequestReportErrorDetails(error);
            this.getErrorDetails().add(ret);
            return ret;
        }).addNames(names);
    }

    public void errorWithoutNames(ModificationRequestReportError error) {
        this.conclusion = ModificationRequestReportConclusion.CANNOT_BE_EXECUTED;
        this.getErrorDetails().stream().filter(detail -> detail.getError() == error).findAny().orElseGet(() -> {
            ModificationRequestReportErrorDetails ret = new ModificationRequestReportErrorDetails(error);
            this.getErrorDetails().add(ret);
            return ret;
        });
    }

    public boolean containsError(ModificationRequestReportError error) {
        return this.getErrorDetails().stream().anyMatch(detail -> detail.getError() == error);
    }

    public List<String> getNamesForError(ModificationRequestReportError error) {
        return this.getErrorDetails().stream().filter(detail -> detail.getError() == error).map(ModificationRequestReportErrorDetails::getNames).findAny().orElse(Collections.emptyList());
    }

    public void change(ModificationRequestReportChange change, String name, String objectName, String subjectName) {
        this.getChangeDetails().stream().filter(detail -> detail.getName().equals(name)).findAny().orElseGet(() -> {
            ModificationRequestReportObjectChangeDetails ret = new ModificationRequestReportObjectChangeDetails(name);
            this.getChangeDetails().add(ret);
            return ret;
        }).getChangeDetails().add(new ModificationRequestReportChangeDetails(change, objectName, subjectName));
    }

    public Optional<Set<ModificationRequestReportChangeDetails>> getChangesForObject(String name) {
        return this.getChangeDetails().stream().filter(detail -> detail.getName().equals(name)).map(ModificationRequestReportObjectChangeDetails::getChangeDetails).findAny();
    }

    public boolean hasNoChanges() {
        return this.changeDetails.isEmpty();
    }

    public List<ModificationRequestReportErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(List<ModificationRequestReportErrorDetails> errorDetails) {
        this.errorDetails = errorDetails;
    }

    public ModificationRequestReportConclusion getConclusion() {
        return this.conclusion;
    }

    public void setConclusion(ModificationRequestReportConclusion conclusion) {
        this.conclusion = conclusion;
    }

    public List<ModificationRequestReportObjectChangeDetails> getChangeDetails() {
        return this.changeDetails;
    }

    public void setChangeDetails(List<ModificationRequestReportObjectChangeDetails> changeDetails) {
        this.changeDetails = changeDetails;
    }
}

