/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.provisioning;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import nl.topicus.cobra.restcontract.annotation.OnResource;
import nl.topicus.cobra.restcontract.annotation.PrimerFor;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.keyhub.servicecontract.annotations.BackendDeterminesDefault;
import nl.topicus.keyhub.servicecontract.annotations.CreateOnly;
import nl.topicus.keyhub.servicecontract.annotations.Immutable;
import nl.topicus.keyhub.servicecontract.model.organization.OrganizationalUnitPrimer;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystem;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystemType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@OnResource(value="/system")
@PrimerFor(value=ProvisionedSystem.class)
public class ProvisionedSystemPrimer
extends Linkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private boolean active;
    @XmlElement
    @Size(max=36)
    @Immutable
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private @Size(max=36) String uuid;
    @XmlElement
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @XmlElement
    @Immutable
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private ProvisionedSystemType type;
    @XmlElement
    @CreateOnly
    @BackendDeterminesDefault
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private OrganizationalUnitPrimer organizationalUnit;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean ownerPermissions;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean adminPermissions;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean contentAdminPermissions;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean canWriteAccounts;

    public ProvisionedSystemPrimer() {
    }

    public ProvisionedSystemPrimer(ProvisionedSystemPrimer system) {
        this.setLink(system.self());
        this.setActive(system.isActive());
        this.setName(system.getName());
        this.setType(system.getType());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProvisionedSystemType getType() {
        return this.type;
    }

    public void setType(ProvisionedSystemType type) {
        this.type = type;
    }

    public OrganizationalUnitPrimer getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public void setOrganizationalUnit(OrganizationalUnitPrimer organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public boolean isOwnerPermissions() {
        return this.ownerPermissions;
    }

    public void setOwnerPermissions(boolean ownerPermissions) {
        this.ownerPermissions = ownerPermissions;
    }

    public boolean isAdminPermissions() {
        return this.adminPermissions;
    }

    public void setAdminPermissions(boolean adminPermissions) {
        this.adminPermissions = adminPermissions;
    }

    public boolean isContentAdminPermissions() {
        return this.contentAdminPermissions;
    }

    public void setContentAdminPermissions(boolean contentAdminPermissions) {
        this.contentAdminPermissions = contentAdminPermissions;
    }

    public boolean isCanWriteAccounts() {
        return this.canWriteAccounts;
    }

    public void setCanWriteAccounts(boolean canWriteAccounts) {
        this.canWriteAccounts = canWriteAccounts;
    }

    @Override
    public String toOmschrijving() {
        return this.getName();
    }
}

