/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.provisioning;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Period;
import java.util.UUID;
import nl.topicus.keyhub.servicecontract.annotations.BackendDeterminesDefault;
import nl.topicus.keyhub.servicecontract.annotations.CreateOnly;
import nl.topicus.keyhub.servicecontract.model.group.GroupPrimer;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupOnSystemProvisioning;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystemPrimer;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public abstract class ProvisionedSystem
extends ProvisionedSystemPrimer {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private int accountCount;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String usernamePrefix;
    @XmlElement
    @NotNull
    @CreateOnly
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private GroupPrimer owner;
    @XmlElement
    @NotNull
    @CreateOnly
    private GroupPrimer technicalAdministrator;
    @XmlElement
    @CreateOnly
    @BackendDeterminesDefault
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private GroupPrimer contentAdministrator;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private UUID externalUuid;
    @XmlElement
    private boolean shouldDestroyUnknownAccounts = false;
    @XmlElement
    private boolean selfServiceNewGroups = true;
    @XmlElement
    private boolean selfServiceExistingGroups = true;
    @XmlElement
    private boolean selfServiceServiceAccounts = true;
    @XmlElement
    private boolean selfServiceNewNamespaces = true;
    @XmlElement
    @NotNull
    private Period cleanupPeriod = Period.ofWeeks(2);
    @XmlElement
    @NotNull
    private GroupOnSystemProvisioning groupOnSystemProvisioning = GroupOnSystemProvisioning.ALWAYS_PROVISIONED;

    public ProvisionedSystem() {
    }

    public ProvisionedSystem(ProvisionedSystemPrimer system) {
        super(system);
    }

    public int getAccountCount() {
        return this.accountCount;
    }

    public void setAccountCount(int accountCount) {
        this.accountCount = accountCount;
    }

    public String getUsernamePrefix() {
        return this.usernamePrefix;
    }

    public void setUsernamePrefix(String usernamePrefix) {
        this.usernamePrefix = usernamePrefix;
    }

    public GroupPrimer getOwner() {
        return this.owner;
    }

    public void setOwner(GroupPrimer owner) {
        this.owner = owner;
    }

    public GroupPrimer getTechnicalAdministrator() {
        return this.technicalAdministrator;
    }

    public void setTechnicalAdministrator(GroupPrimer technicalAdministrator) {
        this.technicalAdministrator = technicalAdministrator;
    }

    public GroupPrimer getContentAdministrator() {
        return this.contentAdministrator;
    }

    public void setContentAdministrator(GroupPrimer contentAdministrator) {
        this.contentAdministrator = contentAdministrator;
    }

    public UUID getExternalUuid() {
        return this.externalUuid;
    }

    public void setExternalUuid(UUID externalUuid) {
        this.externalUuid = externalUuid;
    }

    public boolean isShouldDestroyUnknownAccounts() {
        return this.shouldDestroyUnknownAccounts;
    }

    public void setShouldDestroyUnknownAccounts(boolean shouldDestroyUnknownAccounts) {
        this.shouldDestroyUnknownAccounts = shouldDestroyUnknownAccounts;
    }

    public boolean isSelfServiceNewGroups() {
        return this.selfServiceNewGroups;
    }

    public void setSelfServiceNewGroups(boolean selfServiceNewGroups) {
        this.selfServiceNewGroups = selfServiceNewGroups;
    }

    public boolean isSelfServiceExistingGroups() {
        return this.selfServiceExistingGroups;
    }

    public void setSelfServiceExistingGroups(boolean selfServiceExistingGroups) {
        this.selfServiceExistingGroups = selfServiceExistingGroups;
    }

    public boolean isSelfServiceServiceAccounts() {
        return this.selfServiceServiceAccounts;
    }

    public void setSelfServiceServiceAccounts(boolean selfServiceServiceAccounts) {
        this.selfServiceServiceAccounts = selfServiceServiceAccounts;
    }

    public boolean isSelfServiceNewNamespaces() {
        return this.selfServiceNewNamespaces;
    }

    public void setSelfServiceNewNamespaces(boolean selfServiceNewNamespaces) {
        this.selfServiceNewNamespaces = selfServiceNewNamespaces;
    }

    public Period getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    public void setCleanupPeriod(Period cleanupPeriod) {
        this.cleanupPeriod = cleanupPeriod;
    }

    public GroupOnSystemProvisioning getGroupOnSystemProvisioning() {
        return this.groupOnSystemProvisioning;
    }

    public void setGroupOnSystemProvisioning(GroupOnSystemProvisioning groupOnSystemProvisioning) {
        this.groupOnSystemProvisioning = groupOnSystemProvisioning;
    }
}

