/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.provisioning;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.topicus.cobra.restcontract.annotation.ExcludeFromMapping;
import nl.topicus.cobra.restcontract.annotation.WriteScope;
import nl.topicus.keyhub.servicecontract.annotations.Sensitive;
import nl.topicus.keyhub.servicecontract.model.HttpAuthenticationScheme;
import nl.topicus.keyhub.servicecontract.model.misc.AttributeCustomization;
import nl.topicus.keyhub.servicecontract.model.misc.AttributesCustomizable;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSCIMVendor;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystem;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@WriteScope(value={ProvisionedSCIM.class})
public class ProvisionedSCIM
extends ProvisionedSystem
implements AttributesCustomizable {
    private static final long serialVersionUID = 1L;
    public static final String USERNAME = "/userName";
    public static final String NAME_FORMATTED = "/name/formatted";
    public static final String NAME_FAMILY_NAME = "/name/familyName";
    public static final String NAME_GIVEN_NAME = "/name/givenName";
    public static final String NAME_MIDDLENAME = "/name/middlename";
    public static final String NAME_HONORIFIC_PREFIX = "/name/honorificPrefix";
    public static final String NAME_HONORIFIC_SUFFIX = "/name/honorificSuffix";
    public static final String DISPLAY_NAME = "/displayName";
    public static final String NIKC_NAME = "/nickName";
    public static final String PROFILE_URL = "/profileUrl";
    public static final String TITLE = "/title";
    public static final String USER_TYPE = "/userType";
    public static final String PREFERRED_LANGUAGE = "/preferredLanguage";
    public static final String LOCALE = "/locale";
    public static final String TIME_ZONE = "/timeZone";
    public static final String PRIMARY_EMAIL = "/emails/0/value";
    public static final List<String> CUSTOMIZABLE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("/userName", "/name/formatted", "/name/familyName", "/name/givenName", "/name/middlename", "/name/honorificPrefix", "/name/honorificSuffix", "/displayName", "/nickName", "/profileUrl", "/title", "/userType", "/preferredLanguage", "/locale", "/timeZone", "/emails/0/value"));
    public static final List<String> RESTRICTED_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("/userName", "/emails/0/value"));
    public static final List<String> UNIQUE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("/userName", "/emails/0/value"));
    @XmlElement
    @NotNull
    private ProvisionedSCIMVendor vendor = ProvisionedSCIMVendor.DEFAULT;
    @XmlElement
    @Size(max=512)
    @NotBlank
    private @Size(max=512) @NotBlank String url;
    @XmlElement
    @NotNull
    private HttpAuthenticationScheme authenticationScheme = HttpAuthenticationScheme.NONE;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String basicAuthUsername;
    @Sensitive
    @XmlElement
    private String basicAuthPassword;
    @Sensitive
    @XmlElement
    private String bearerToken;
    @XmlElement
    @Size(max=64)
    private @Size(max=64) String customHeaderName;
    @Sensitive
    @XmlElement
    private String customHeaderValue;
    @XmlElement
    @ExcludeFromMapping
    private List<AttributeCustomization> attributes = new ArrayList<AttributeCustomization>();

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpAuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public void setAuthenticationScheme(HttpAuthenticationScheme authenticationScheme) {
        this.authenticationScheme = authenticationScheme;
    }

    public String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    public void setBasicAuthUsername(String basicAuthUsername) {
        this.basicAuthUsername = basicAuthUsername;
    }

    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    public void setBasicAuthPassword(String basicAuthPassword) {
        this.basicAuthPassword = basicAuthPassword;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public String getCustomHeaderName() {
        return this.customHeaderName;
    }

    public void setCustomHeaderName(String customHeaderName) {
        this.customHeaderName = customHeaderName;
    }

    public String getCustomHeaderValue() {
        return this.customHeaderValue;
    }

    public void setCustomHeaderValue(String customHeaderValue) {
        this.customHeaderValue = customHeaderValue;
    }

    public ProvisionedSCIMVendor getVendor() {
        return this.vendor;
    }

    public void setVendor(ProvisionedSCIMVendor vendor) {
        this.vendor = vendor;
    }

    @Override
    public List<AttributeCustomization> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<AttributeCustomization> attributes) {
        this.attributes = attributes;
    }
}

