/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.provisioning;

public enum GroupOnSystemType {
    POSIX_GROUP(true, "gos.ldap"),
    GROUP_OF_NAMES(true, "gos.ldap"),
    GROUP_OF_UNIQUE_NAMES(true, "gos.ldap"),
    GROUP_GLOBAL_SECURITY(true, "gos.ad"),
    GROUP_LOCAL_SECURITY(true, "gos.ad"),
    GROUP_UNIVERSAL_SECURITY(true, "gos.ad"),
    GROUP_UNKNOWN(false, "gos.ad"){

        @Override
        public boolean isDeprovisioningSupported() {
            return true;
        }
    }
    ,
    AZURE_ROLE(false, "gos.azurerole"),
    AZURE_UNIFIED_GROUP(true, "gos.azureunified"),
    AZURE_SECURITY_GROUP(true, "gos.azuresecurity"),
    SCIM(true, "gos.scim"),
    ACCOUNT_ONLY(false, "gos.accountonly");

    private boolean provisioningSupported;
    private String resourceKey;

    private GroupOnSystemType(boolean provisioningSupported, String resourceKey) {
        this.provisioningSupported = provisioningSupported;
        this.resourceKey = resourceKey;
    }

    public boolean isProvisioningSupported() {
        return this.provisioningSupported;
    }

    public boolean isDeprovisioningSupported() {
        return this.provisioningSupported;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }
}

