/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.provisioning;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import nl.topicus.cobra.restcontract.annotation.ExcludeFromMapping;
import nl.topicus.keyhub.servicecontract.annotations.CertificateOnly;
import nl.topicus.keyhub.servicecontract.annotations.Sensitive;
import nl.topicus.keyhub.servicecontract.model.CertificateHolder;
import nl.topicus.keyhub.servicecontract.model.TLSLevel;
import nl.topicus.keyhub.servicecontract.model.certificate.CertificatePrimer;
import nl.topicus.keyhub.servicecontract.model.misc.AttributeCustomization;
import nl.topicus.keyhub.servicecontract.model.misc.AttributesCustomizable;
import nl.topicus.keyhub.servicecontract.model.provisioning.LDAPSshPublicKeySupport;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystem;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public abstract class AbstractProvisionedLDAP
extends ProvisionedSystem
implements CertificateHolder,
AttributesCustomizable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String host;
    @XmlElement
    private int port;
    @XmlElement
    private String failoverHost;
    @XmlElement
    @NotNull
    private TLSLevel tls;
    @XmlElement
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String baseDN;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String bindDN;
    @Sensitive
    @XmlElement
    @Size(max=128)
    private @Size(max=128) String bindPassword;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String userDN;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String serviceAccountDN;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String groupDN;
    @XmlElement
    @NotNull
    private LDAPSshPublicKeySupport sshPublicKeySupport = LDAPSshPublicKeySupport.SSH_PUBLIC_KEY;
    @XmlElement
    @Size(max=255)
    private @Size(max=255) String objectClasses;
    @XmlElement
    @CertificateOnly
    @ExcludeFromMapping
    private CertificatePrimer trustedCertificate;
    @XmlElement
    @CertificateOnly
    @ExcludeFromMapping
    private CertificatePrimer failoverTrustedCertificate;
    @XmlElement
    @ExcludeFromMapping
    private CertificatePrimer clientCertificate;
    @XmlElement
    @ExcludeFromMapping
    private List<AttributeCustomization> attributes = new ArrayList<AttributeCustomization>();

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFailoverHost() {
        return this.failoverHost;
    }

    public void setFailoverHost(String failoverHost) {
        this.failoverHost = failoverHost;
    }

    @Override
    public TLSLevel getTls() {
        return this.tls;
    }

    @Override
    public void setTls(TLSLevel tls) {
        this.tls = tls;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
    }

    public String getUserDN() {
        return this.userDN;
    }

    public void setUserDN(String userDN) {
        this.userDN = userDN;
    }

    public String getServiceAccountDN() {
        return this.serviceAccountDN;
    }

    public void setServiceAccountDN(String serviceAccountDN) {
        this.serviceAccountDN = serviceAccountDN;
    }

    public String getGroupDN() {
        return this.groupDN;
    }

    public void setGroupDN(String groupDN) {
        this.groupDN = groupDN;
    }

    public LDAPSshPublicKeySupport getSshPublicKeySupport() {
        return this.sshPublicKeySupport;
    }

    public void setSshPublicKeySupport(LDAPSshPublicKeySupport sshPublicKeySupport) {
        this.sshPublicKeySupport = sshPublicKeySupport;
    }

    public String getObjectClasses() {
        return this.objectClasses;
    }

    public void setObjectClasses(String objectClasses) {
        this.objectClasses = objectClasses;
    }

    @Override
    public CertificatePrimer getTrustedCertificate() {
        return this.trustedCertificate;
    }

    @Override
    public void setTrustedCertificate(CertificatePrimer trustedCertificate) {
        this.trustedCertificate = trustedCertificate;
    }

    @Override
    public CertificatePrimer getFailoverTrustedCertificate() {
        return this.failoverTrustedCertificate;
    }

    @Override
    public void setFailoverTrustedCertificate(CertificatePrimer failoverTrustedCertificate) {
        this.failoverTrustedCertificate = failoverTrustedCertificate;
    }

    @Override
    public CertificatePrimer getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public void setClientCertificate(CertificatePrimer clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    @Override
    public List<AttributeCustomization> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<AttributeCustomization> attributes) {
        this.attributes = attributes;
    }
}

