/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.notification;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import nl.topicus.keyhub.servicecontract.model.group.GroupPrimer;
import nl.topicus.keyhub.servicecontract.model.notification.Notification;
import nl.topicus.keyhub.servicecontract.model.notification.NotificationContext;
import nl.topicus.keyhub.servicecontract.model.vault.VaultRecord;
import nl.topicus.keyhub.servicecontract.resources.VaultRecordResource;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VaultRecordExpiredNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private VaultRecord record;

    @Override
    public VaultRecord getSubject() {
        return this.record;
    }

    public VaultRecord getRecord() {
        return this.record;
    }

    public void setRecord(VaultRecord record) {
        this.record = record;
    }

    @Override
    public String getDescriptionI18NKey(NotificationContext context) {
        return "notification.vaultrecordexpired" + (this.isExpired() ? ".hasexpired" : ".expiresoon") + (this.isFromGroup() ? ".group" : ".personal");
    }

    private boolean isExpired() {
        return this.record.getEndDate().isBefore(LocalDate.now());
    }

    private boolean isFromGroup() {
        return this.record.getAdditionalObjects(VaultRecordResource.VAULTHOLDER) instanceof GroupPrimer;
    }

    @Override
    public Map<String, Object> getI18NNamedParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("recordName", this.record.getName());
        params.put("vaultName", this.record.getAdditionalObjects(VaultRecordResource.VAULTHOLDER).toOmschrijving());
        params.put("endDate", this.record.getEndDate());
        return params;
    }
}

