/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.notification;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import java.util.Objects;
import nl.topicus.cobra.restcontract.model.Link;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.cobra.restcontract.model.NonLinkable;
import nl.topicus.keyhub.servicecontract.model.notification.NotificationContext;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Notification
extends NonLinkable {
    private static final long serialVersionUID = 1L;
    public static final String MAIL_KEY_SEPARATOR = "|";
    private String inPlainText;

    public String getInPlainText() {
        return this.inPlainText;
    }

    public void setInPlainText(String inPlainText) {
        this.inPlainText = inPlainText;
    }

    @XmlTransient
    public abstract Linkable getSubject();

    public abstract String getDescriptionI18NKey(NotificationContext var1);

    public abstract Map<String, Object> getI18NNamedParameters();

    public String mailKey() {
        return this.generateMailKey(this.getClass().getName(), this.getSubject());
    }

    protected String generateMailKey(Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (Object curArg : args) {
            if (curArg instanceof Linkable) {
                for (Link curLink : ((Linkable)curArg).getLinks()) {
                    sb.append(String.valueOf(curLink.getHref()));
                }
                continue;
            }
            sb.append(String.valueOf(curArg));
        }
        return sb.toString().replace(MAIL_KEY_SEPARATOR, "");
    }

    public int hashCode() {
        return Objects.hash(this.getClass().getName(), this.getSubject());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof Notification) {
            Link otherSubSelf;
            Notification other = (Notification)obj;
            Link thisSubSelf = this.getSubject() == null ? null : this.getSubject().self();
            Link link = otherSubSelf = other.getSubject() == null ? null : other.getSubject().self();
            if (thisSubSelf == null && otherSubSelf == null) {
                if (this.getSubject() == null != (other.getSubject() == null)) {
                    return false;
                }
                if (this.getSubject() != null) {
                    return Objects.equals(this.getSubject().toOmschrijving(), other.getSubject().toOmschrijving());
                }
            }
            return Objects.equals(otherSubSelf, thisSubSelf);
        }
        return false;
    }
}

