/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.notification;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.topicus.keyhub.servicecontract.model.notification.Notification;
import nl.topicus.keyhub.servicecontract.model.notification.NotificationContext;
import nl.topicus.keyhub.servicecontract.model.provisioning.GroupOnSystem;
import nl.topicus.keyhub.servicecontract.model.request.AbstractAccessProfileModificationRequest;
import nl.topicus.keyhub.servicecontract.model.request.AbstractApplicationModificationRequest;
import nl.topicus.keyhub.servicecontract.model.request.AbstractOrganizationalUnitModificationRequest;
import nl.topicus.keyhub.servicecontract.model.request.AbstractProvisionedSystemModificationRequest;
import nl.topicus.keyhub.servicecontract.model.request.AddGroupAdminRequest;
import nl.topicus.keyhub.servicecontract.model.request.CreateGroupOnSystemRequest;
import nl.topicus.keyhub.servicecontract.model.request.CreateGroupRequest;
import nl.topicus.keyhub.servicecontract.model.request.CreateProvisionedNamespaceRequest;
import nl.topicus.keyhub.servicecontract.model.request.CreateServiceAccountRequest;
import nl.topicus.keyhub.servicecontract.model.request.ExtendAccessRequest;
import nl.topicus.keyhub.servicecontract.model.request.GrantApplicationRequest;
import nl.topicus.keyhub.servicecontract.model.request.GrantClientPermissionRequest;
import nl.topicus.keyhub.servicecontract.model.request.GrantGroupOnSystemRequest;
import nl.topicus.keyhub.servicecontract.model.request.GrantGroupOnSystemRequestRequest;
import nl.topicus.keyhub.servicecontract.model.request.GrantServiceAccountGroupRequest;
import nl.topicus.keyhub.servicecontract.model.request.JoinGroupRequest;
import nl.topicus.keyhub.servicecontract.model.request.LinkDirectoryToAccessProfileRequest;
import nl.topicus.keyhub.servicecontract.model.request.ModificationRequest;
import nl.topicus.keyhub.servicecontract.model.request.MoveGroupsRequest;
import nl.topicus.keyhub.servicecontract.model.request.RemoveGroupRequest;
import nl.topicus.keyhub.servicecontract.model.request.RemoveOrganizationalUnitRequest;
import nl.topicus.keyhub.servicecontract.model.request.RemoveProvisionedSystemRequest;
import nl.topicus.keyhub.servicecontract.model.request.RevokeAdminRequest;
import nl.topicus.keyhub.servicecontract.model.request.SetupAuthorizingGroupRequest;
import nl.topicus.keyhub.servicecontract.model.request.SetupNestedGroupRequest;
import nl.topicus.keyhub.servicecontract.model.request.TransferGroupOnSystemOwnershipRequest;
import nl.topicus.keyhub.servicecontract.model.request.TransferServiceAccountAdministrationRequest;
import nl.topicus.keyhub.servicecontract.model.request.UpdateGroupMembershipRequest;
import nl.topicus.keyhub.servicecontract.model.request.VerifyInternalAccountRequest;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ModificationRequestNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private ModificationRequest request;
    @XmlElement(name="admin")
    @XmlElementWrapper(name="admins")
    private List<String> admins = new ArrayList<String>();
    @XmlElement(name="group")
    @XmlElementWrapper(name="groups")
    private List<String> groups = new ArrayList<String>();

    @Override
    public ModificationRequest getSubject() {
        return this.request;
    }

    public ModificationRequest getRequest() {
        return this.request;
    }

    public void setRequest(ModificationRequest request) {
        this.request = request;
    }

    public List<String> getAdmins() {
        return this.admins;
    }

    public void setAdmins(List<String> admins) {
        this.admins = admins;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    public String getDescriptionI18NKey(NotificationContext context) {
        JoinGroupRequest joinRequest;
        StringBuilder selector = new StringBuilder("modrequest.long");
        selector.append('.').append(this.request.getType().name().toLowerCase().replace("_", ""));
        if (this.request instanceof SetupAuthorizingGroupRequest) {
            SetupAuthorizingGroupRequest setupAuthRequest = (SetupAuthorizingGroupRequest)this.request;
            selector.append(".").append((Object)setupAuthRequest.getAuthorizingGroupType());
            if (setupAuthRequest.isConnect()) {
                selector.append(".connect");
            } else {
                selector.append(".disconnect");
            }
        } else if (this.request instanceof SetupNestedGroupRequest) {
            SetupNestedGroupRequest setupNestRequest = (SetupNestedGroupRequest)this.request;
            if (setupNestRequest.isConnect()) {
                selector.append(".connect.");
            } else {
                selector.append(".disconnect.");
            }
            selector.append(setupNestRequest.getAccountAction().name().toLowerCase());
        } else if (this.request instanceof GrantClientPermissionRequest) {
            selector.append(".").append((Object)((GrantClientPermissionRequest)this.request).getPermissionType());
        } else if (this.request instanceof UpdateGroupMembershipRequest) {
            if (((UpdateGroupMembershipRequest)this.request).isAddMember()) {
                selector.append(".add");
            } else {
                selector.append(".update");
            }
        } else if (this.request instanceof GrantApplicationRequest) {
            GrantApplicationRequest grantRequest = (GrantApplicationRequest)this.request;
            if (grantRequest.getAccessProfile() != null) {
                selector.append(".profile");
            } else {
                selector.append(".group");
            }
        } else if (this.request instanceof GrantGroupOnSystemRequest) {
            GrantGroupOnSystemRequest grantRequest = (GrantGroupOnSystemRequest)this.request;
            if (grantRequest.getAccessProfile() != null) {
                selector.append(".profile");
            } else if (grantRequest.isActivationRequired()) {
                selector.append(".dynamic");
            } else {
                selector.append(".static");
            }
        } else if (this.request instanceof GrantGroupOnSystemRequestRequest) {
            GrantGroupOnSystemRequestRequest grantRequest = (GrantGroupOnSystemRequestRequest)this.request;
            if (grantRequest.getAccessProfile() != null) {
                selector.append(".profile");
            } else if (grantRequest.isActivationRequired()) {
                selector.append(".dynamic");
            } else {
                selector.append(".static");
            }
        } else if (this.request instanceof CreateGroupRequest) {
            if (context.isInMultipleOrganizationalUnits()) {
                selector.append(".ou");
            }
        } else if (this.request instanceof CreateGroupOnSystemRequest) {
            CreateGroupOnSystemRequest gosRequest = (CreateGroupOnSystemRequest)this.request;
            selector.append(gosRequest.getAccessProfile() != null ? ".profile" : ".group");
        } else if (this.request instanceof JoinGroupRequest && (joinRequest = (JoinGroupRequest)this.request).getAccessProfile() != null) {
            selector.append(".profile");
        }
        if (context.getAccount().equals(this.getSubject().getAccount())) {
            selector.append(".me");
        }
        return selector.toString();
    }

    @Override
    public Map<String, Object> getI18NNamedParameters() {
        ModificationRequest transferRequest;
        GroupOnSystem gos;
        GroupOnSystem gos2;
        ModificationRequest grantRequest;
        AbstractAccessProfileModificationRequest accesProfileRequest;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("requester", this.request.getAccount().toOmschrijving());
        String groupName = null;
        if (this.request.getGroup() != null) {
            groupName = this.request.getGroup().getName();
        } else if (this.request instanceof RemoveGroupRequest) {
            groupName = ((RemoveGroupRequest)this.request).getGroupName();
        } else if (this.request instanceof CreateGroupRequest) {
            groupName = ((CreateGroupRequest)this.request).getGroupName();
        }
        if (groupName != null) {
            params.put("groupName", groupName);
        }
        if (this.request instanceof AddGroupAdminRequest) {
            params.put("newAdmin", ((AddGroupAdminRequest)this.request).getNewAdmin().toOmschrijving());
        }
        if (this.request instanceof AbstractApplicationModificationRequest) {
            params.put("application", ((AbstractApplicationModificationRequest)this.request).getApplication().toOmschrijving());
        }
        if (this.request instanceof AbstractAccessProfileModificationRequest && (accesProfileRequest = (AbstractAccessProfileModificationRequest)this.request).getAccessProfile() != null) {
            params.put("accessProfile", accesProfileRequest.getAccessProfile().toOmschrijving());
        }
        if (this.request instanceof CreateServiceAccountRequest) {
            params.put("username", ((CreateServiceAccountRequest)this.request).getUsername());
        }
        if (this.request instanceof CreateGroupOnSystemRequest) {
            CreateGroupOnSystemRequest gosRequest = (CreateGroupOnSystemRequest)this.request;
            params.put("gosName", gosRequest.getNameInSystem());
            params.put("gosType", (Object)gosRequest.getGroupOnSystemType());
            if (gosRequest.getAccessProfile() != null) {
                params.put("accessProfile", gosRequest.getAccessProfile().toOmschrijving());
            }
        }
        if (this.request instanceof CreateProvisionedNamespaceRequest) {
            CreateProvisionedNamespaceRequest cpnRequest = (CreateProvisionedNamespaceRequest)this.request;
            params.put("namespaceName", cpnRequest.getNamespaceName());
        }
        if (this.request instanceof ExtendAccessRequest) {
            params.put("extendUntil", ((ExtendAccessRequest)this.request).getExtendUntil());
        }
        if (this.request instanceof GrantApplicationRequest) {
            grantRequest = (GrantApplicationRequest)this.request;
            params.put("application", ((GrantApplicationRequest)grantRequest).getApplication().toOmschrijving());
        }
        if (this.request instanceof GrantClientPermissionRequest) {
            GrantClientPermissionRequest permRequest = (GrantClientPermissionRequest)this.request;
            params.put("permissionType", (Object)permRequest.getPermissionType());
            if (permRequest.getSystem() != null) {
                params.put("system", permRequest.getSystem().toOmschrijving());
            }
            if (permRequest.getGroup() != null) {
                params.put("group", permRequest.getGroup().toOmschrijving());
            }
        }
        if (this.request instanceof GrantGroupOnSystemRequest) {
            gos2 = ((GrantGroupOnSystemRequest)this.request).getGroupOnSystem();
            params.put("gosType", (Object)gos2.getType());
            params.put("gosName", gos2);
            params.put("system", gos2.getSystem().toOmschrijving());
            params.put("originalRequester", ((GrantGroupOnSystemRequest)this.request).getOriginalRequester().toOmschrijving());
        }
        if (this.request instanceof GrantGroupOnSystemRequestRequest) {
            gos2 = ((GrantGroupOnSystemRequestRequest)this.request).getGroupOnSystem();
            params.put("gosType", (Object)gos2.getType());
            params.put("gosName", gos2);
            params.put("system", gos2.getSystem().toOmschrijving());
        }
        if (this.request instanceof GrantServiceAccountGroupRequest) {
            grantRequest = (GrantServiceAccountGroupRequest)this.request;
            gos = ((GrantServiceAccountGroupRequest)grantRequest).getGroupOnSystem();
            params.put("gosType", (Object)gos.getType());
            params.put("gosName", gos);
            params.put("system", gos.getSystem().toOmschrijving());
            params.put("serviceAccount", ((GrantServiceAccountGroupRequest)grantRequest).getServiceAccount().toOmschrijving());
        }
        if (this.request instanceof LinkDirectoryToAccessProfileRequest) {
            LinkDirectoryToAccessProfileRequest linkRequest = (LinkDirectoryToAccessProfileRequest)this.request;
            params.put("directory", linkRequest.getDirectory().getName());
        }
        if (this.request instanceof RemoveProvisionedSystemRequest) {
            params.put("system", ((RemoveProvisionedSystemRequest)this.request).getSystemName());
        } else if (this.request instanceof AbstractProvisionedSystemModificationRequest) {
            params.put("system", ((AbstractProvisionedSystemModificationRequest)this.request).getSystem().toOmschrijving());
        }
        if (this.request instanceof RemoveOrganizationalUnitRequest) {
            params.put("organizationalUnit", ((RemoveOrganizationalUnitRequest)this.request).getOrganizationalUnitName());
        } else if (this.request instanceof AbstractOrganizationalUnitModificationRequest) {
            params.put("organizationalUnit", ((AbstractOrganizationalUnitModificationRequest)this.request).getOrganizationalUnit().getName());
            if (this.request instanceof MoveGroupsRequest) {
                params.put("groupCount", ((MoveGroupsRequest)this.request).getGroupCount());
            }
        }
        if (this.request instanceof RevokeAdminRequest) {
            params.put("admin", ((RevokeAdminRequest)this.request).getAdmin().toOmschrijving());
        }
        if (this.request instanceof SetupAuthorizingGroupRequest) {
            SetupAuthorizingGroupRequest setupAuthRequest = (SetupAuthorizingGroupRequest)this.request;
            params.put("requestingGroup", setupAuthRequest.getRequestingGroup().toOmschrijving());
        }
        if (this.request instanceof SetupNestedGroupRequest) {
            SetupNestedGroupRequest setupNestedRequest = (SetupNestedGroupRequest)this.request;
            params.put("requestingGroup", setupNestedRequest.getRequestingGroup().toOmschrijving());
        }
        if (this.request instanceof TransferGroupOnSystemOwnershipRequest) {
            transferRequest = (TransferGroupOnSystemOwnershipRequest)this.request;
            gos = ((TransferGroupOnSystemOwnershipRequest)transferRequest).getGroupOnSystem();
            params.put("gosType", (Object)gos.getType());
            params.put("gosName", gos);
            params.put("system", ((TransferGroupOnSystemOwnershipRequest)transferRequest).getGroupOnSystem().getSystem().toOmschrijving());
        }
        if (this.request instanceof TransferServiceAccountAdministrationRequest) {
            transferRequest = (TransferServiceAccountAdministrationRequest)this.request;
            params.put("serviceAccount", ((TransferServiceAccountAdministrationRequest)transferRequest).getServiceAccount().getName());
            params.put("system", ((TransferServiceAccountAdministrationRequest)transferRequest).getServiceAccount().getSystem().toOmschrijving());
        }
        if (this.request instanceof UpdateGroupMembershipRequest) {
            UpdateGroupMembershipRequest updateRequest = (UpdateGroupMembershipRequest)this.request;
            params.put("accountToUpdate", updateRequest.getAccountToUpdate().toOmschrijving());
        }
        if (this.request instanceof VerifyInternalAccountRequest) {
            VerifyInternalAccountRequest verifyRequest = (VerifyInternalAccountRequest)this.request;
            params.put("targetAccount", verifyRequest.getInternalAccountName());
            params.put("targetDirectory", verifyRequest.getDirectory().getName());
        }
        return params;
    }
}

