/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.notification;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import nl.topicus.cobra.restcontract.xmladapter.StringMapAdapter;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.group.GroupEditRequiredReason;
import nl.topicus.keyhub.servicecontract.model.notification.Notification;
import nl.topicus.keyhub.servicecontract.model.notification.NotificationContext;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GroupEditRequiredNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    public static final String AUDIT_INTERVAL = "interval";
    public static final String AUDIT_MONTHS = "months";
    public static final String MINIMUM_NR_MANAGERS = "minimumNrManagers";
    @XmlElement
    private Group group;
    @XmlElement
    private GroupEditRequiredReason reason;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringMapAdapter.class)
    private Map<String, String> parameters = new HashMap<String, String>();

    @Override
    public Group getSubject() {
        return this.getGroup();
    }

    @Override
    public String mailKey() {
        return super.mailKey() + this.generateMailKey(new Object[]{this.reason});
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass().getName(), this.getSubject(), this.reason});
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof GroupEditRequiredNotification) {
            GroupEditRequiredNotification other = (GroupEditRequiredNotification)obj;
            return other.getReason().equals((Object)this.reason);
        }
        return false;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public GroupEditRequiredReason getReason() {
        return this.reason;
    }

    public void setReason(GroupEditRequiredReason reason) {
        this.reason = reason;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getDescriptionI18NKey(NotificationContext context) {
        String ret = "notification.groupeditrequired." + this.reason.name() + ".long";
        if (this.reason.equals((Object)GroupEditRequiredReason.CRITERIA_UNSATISFIED_AUDIT_INTERVAL)) {
            int interval = Integer.parseInt(this.parameters.get(AUDIT_INTERVAL));
            return interval < 2 || interval == 12 ? ret + "." + interval : ret + ".n";
        }
        return ret;
    }

    @Override
    public Map<String, Object> getI18NNamedParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupName", this.group.getName());
        if (this.parameters != null) {
            params.putAll(this.parameters);
        }
        return params;
    }
}

