/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.notification;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import nl.topicus.keyhub.servicecontract.model.audit.AuditRequiredSourceType;
import nl.topicus.keyhub.servicecontract.model.audit.AuditRequiredStatus;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.notification.Notification;
import nl.topicus.keyhub.servicecontract.model.notification.NotificationContext;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GroupAuditRequiredNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private Group group;
    @XmlElement
    private AuditRequiredSourceType type;
    @XmlElement
    private Instant dueDate;

    @Override
    public Group getSubject() {
        return this.getGroup();
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public AuditRequiredSourceType getType() {
        return this.type;
    }

    public void setType(AuditRequiredSourceType type) {
        this.type = type;
    }

    public Instant getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Instant dueDate) {
        this.dueDate = dueDate;
    }

    public AuditRequiredStatus getStatus() {
        if (this.dueDate == null) {
            return AuditRequiredStatus.NONE;
        }
        if (Instant.now().isAfter(this.dueDate)) {
            return AuditRequiredStatus.OVERDUE;
        }
        return AuditRequiredStatus.PENDING;
    }

    @Override
    public String getDescriptionI18NKey(NotificationContext context) {
        return "notification.groupauditrequested.description.long";
    }

    @Override
    public Map<String, Object> getI18NNamedParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupName", this.group.getName());
        return params;
    }
}

