/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.notification;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import nl.topicus.cobra.restcontract.model.Linkable;
import nl.topicus.keyhub.servicecontract.model.certificate.Certificate;
import nl.topicus.keyhub.servicecontract.model.client.LdapClient;
import nl.topicus.keyhub.servicecontract.model.directory.LDAPDirectory;
import nl.topicus.keyhub.servicecontract.model.notification.CertificateUsage;
import nl.topicus.keyhub.servicecontract.model.notification.Notification;
import nl.topicus.keyhub.servicecontract.model.notification.NotificationContext;
import nl.topicus.keyhub.servicecontract.model.provisioning.ProvisionedSystem;
import nl.topicus.keyhub.servicecontract.model.webhook.Webhook;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CertificateExpiredNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private CertificateUsage usage;
    @XmlElement
    private LDAPDirectory directory;
    @XmlElement
    private ProvisionedSystem system;
    @XmlElement
    private Webhook webhook;
    @XmlElement
    private LdapClient ldapClient;
    @XmlElement
    private Certificate certificate;
    @XmlElement
    private Instant expiration;

    @Override
    public Linkable getSubject() {
        if (this.directory != null) {
            return this.directory;
        }
        if (this.system != null) {
            return this.system;
        }
        if (this.webhook != null) {
            return this.webhook;
        }
        if (this.ldapClient != null) {
            return this.ldapClient;
        }
        return this.certificate;
    }

    @Override
    public String mailKey() {
        return super.mailKey() + this.generateMailKey(new Object[]{this.usage});
    }

    @Override
    public String getDescriptionI18NKey(NotificationContext context) {
        return "notification.certificateexpired." + (this.isExpired() ? "hasexpired." : "expiresoon.") + this.getI18NSuffix();
    }

    @Override
    public Map<String, Object> getI18NNamedParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expiration", this.getExpiration());
        params.put("description", this.getSubject().toOmschrijving());
        params.put("subjectName", this.getWebhookSubjectName());
        return params;
    }

    public CertificateUsage getUsage() {
        return this.usage;
    }

    public void setUsage(CertificateUsage usage) {
        this.usage = usage;
    }

    public LDAPDirectory getDirectory() {
        return this.directory;
    }

    public void setDirectory(LDAPDirectory directory) {
        this.directory = directory;
    }

    public ProvisionedSystem getSystem() {
        return this.system;
    }

    public void setSystem(ProvisionedSystem system) {
        this.system = system;
    }

    public Webhook getWebhook() {
        return this.webhook;
    }

    public void setWebhook(Webhook webhook) {
        this.webhook = webhook;
    }

    public LdapClient getLdapClient() {
        return this.ldapClient;
    }

    public void setLdapClient(LdapClient ldapClient) {
        this.ldapClient = ldapClient;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Instant expiration) {
        this.expiration = expiration;
    }

    private boolean isExpired() {
        return this.expiration.isBefore(Instant.now());
    }

    public String getWebhookSubjectName() {
        if (this.usage.equals((Object)CertificateUsage.WEBHOOK)) {
            if (this.webhook.getClient() != null) {
                return this.webhook.getClient().getName();
            }
            if (this.webhook.getDirectory() != null) {
                return this.webhook.getDirectory().getName();
            }
            if (this.webhook.getGroup() != null) {
                return this.webhook.getGroup().getName();
            }
            if (this.webhook.getSystem() != null) {
                return this.webhook.getSystem().getName();
            }
        }
        return null;
    }

    private String getI18NSuffix() {
        if (this.usage.equals((Object)CertificateUsage.WEBHOOK)) {
            if (this.webhook.getClient() == null && this.webhook.getDirectory() == null && this.webhook.getGroup() == null && this.webhook.getSystem() == null) {
                return CertificateUsage.WEBHOOK.name() + ".global";
            }
            return CertificateUsage.WEBHOOK.name() + ".restricted";
        }
        return this.usage.name();
    }
}

