/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.license;

import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.topicus.cobra.restcontract.model.NonLinkable;
import nl.topicus.keyhub.servicecontract.model.license.LicenseFeature;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class KeyHubLicenseInfo
extends NonLinkable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private int version;
    @XmlElement
    @Size(max=36)
    private @Size(max=36) String uuid;
    @XmlElement
    @Size(max=100)
    private @Size(max=100) String customerCompany;
    @XmlElement
    @Size(max=100)
    private @Size(max=100) String customerContact;
    @XmlElement
    @Size(max=100)
    private @Size(max=100) List<String> customerDomains = new ArrayList<String>();
    @XmlElement
    private Instant issueTime;
    @XmlElement
    private Instant notBeforeTime;
    @XmlElement
    private Instant expirationTime;
    @XmlElement
    private Integer usersSoftLimit;
    @XmlElement
    private Integer usersHardLimit;
    @XmlElement
    private Integer usersBusinessLimit;
    @XmlElement
    private Integer usersProLimit;
    @XmlElement
    private Set<LicenseFeature> features = new HashSet<LicenseFeature>();
    @XmlElement
    private String licenseKey;
    @XmlElement
    private String keyHubDomain;
    @XmlElement
    private LicenseStatus currentLicenseStatus;

    public KeyHubLicenseInfo() {
    }

    public KeyHubLicenseInfo(KeyHubLicenseInfo copy) {
        this.version = copy.version;
        this.uuid = copy.uuid;
        this.customerCompany = copy.customerCompany;
        this.customerContact = copy.customerContact;
        this.customerDomains = new ArrayList<String>(copy.customerDomains);
        this.issueTime = copy.issueTime;
        this.notBeforeTime = copy.notBeforeTime;
        this.expirationTime = copy.expirationTime;
        this.usersHardLimit = copy.usersHardLimit;
        this.usersBusinessLimit = copy.usersBusinessLimit;
        this.usersProLimit = copy.usersProLimit;
        this.features = new HashSet<LicenseFeature>(copy.features);
        this.licenseKey = copy.licenseKey;
        this.keyHubDomain = copy.keyHubDomain;
        this.currentLicenseStatus = copy.currentLicenseStatus;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getCustomerCompany() {
        return this.customerCompany;
    }

    public void setCustomerCompany(String customerCompany) {
        this.customerCompany = customerCompany;
    }

    public String getCustomerContact() {
        return this.customerContact;
    }

    public void setCustomerContact(String customerContact) {
        this.customerContact = customerContact;
    }

    public List<String> getCustomerDomains() {
        return this.customerDomains;
    }

    public void setCustomerDomains(List<String> customerDomains) {
        this.customerDomains = customerDomains == null ? new ArrayList<String>() : customerDomains;
    }

    public Instant getIssueTime() {
        return this.issueTime;
    }

    public void setIssueTime(Instant issueTime) {
        this.issueTime = issueTime;
    }

    public Instant getNotBeforeTime() {
        return this.notBeforeTime;
    }

    public void setNotBeforeTime(Instant notBeforeTime) {
        this.notBeforeTime = notBeforeTime;
    }

    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Instant expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Integer getUsersSoftLimit() {
        return this.usersSoftLimit;
    }

    public void setUsersSoftLimit(Integer usersSoftLimit) {
        this.usersSoftLimit = usersSoftLimit;
    }

    public Integer getUsersHardLimit() {
        return this.usersHardLimit;
    }

    public void setUsersHardLimit(Integer usersHardLimit) {
        this.usersHardLimit = usersHardLimit;
    }

    public Integer getUsersBusinessLimit() {
        return this.usersBusinessLimit;
    }

    public void setUsersBusinessLimit(Integer usersBusinessLimit) {
        this.usersBusinessLimit = usersBusinessLimit;
    }

    public Integer getUsersProLimit() {
        return this.usersProLimit;
    }

    public void setUsersProLimit(Integer usersProLimit) {
        this.usersProLimit = usersProLimit;
    }

    public Set<LicenseFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Set<LicenseFeature> features) {
        this.features = features == null ? new HashSet<LicenseFeature>() : features;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public String getKeyHubDomain() {
        return this.keyHubDomain;
    }

    public void setKeyHubDomain(String keyHubDomain) {
        this.keyHubDomain = keyHubDomain;
    }

    public List<URI> getCustomerDomainsAsUri() throws URISyntaxException {
        ArrayList<URI> ret = new ArrayList<URI>();
        for (String domain : this.getCustomerDomains()) {
            if (domain.contains("://")) {
                ret.add(new URI(domain));
                continue;
            }
            ret.add(new URI("https://" + domain));
        }
        return ret;
    }

    public LicenseStatus getCurrentLicenseStatus() {
        return this.currentLicenseStatus;
    }

    public void setCurrentLicenseStatus(LicenseStatus currentLicenseStatus) {
        this.currentLicenseStatus = currentLicenseStatus;
    }

    public boolean isOK() {
        return LicenseStatus.OK.equals((Object)this.getCurrentLicenseStatus());
    }

    public boolean isCorrect() {
        boolean requiredSet;
        boolean bl = requiredSet = this.getUuid() != null && this.getVersion() > 3 && this.getCustomerCompany() != null && this.getCustomerContact() != null && this.getIssueTime() != null && this.getNotBeforeTime() != null;
        if (!requiredSet) {
            return false;
        }
        try {
            this.getCustomerDomainsAsUri();
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static enum LicenseStatus {
        OK,
        NOT_YET_VALID,
        EXPIRED,
        TERMINATED,
        SOFT_LIMIT_REACHED,
        HARD_LIMIT_REACHED,
        HARD_LIMIT_EXCEEDED,
        WRONG_DOMAIN,
        BUSINESS_LIMIT_EXCEEDED,
        PRO_LIMIT_EXCEEDED,
        FEATURE_IN_USE;

    }
}

