/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.group;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Instant;
import java.time.LocalDate;
import nl.topicus.cobra.restcontract.annotation.OnResource;
import nl.topicus.cobra.restcontract.annotation.PrimerFor;
import nl.topicus.cobra.restcontract.annotation.WriteRelation;
import nl.topicus.cobra.restcontract.annotation.WriteScope;
import nl.topicus.keyhub.servicecontract.model.auth.AccountPrimer;
import nl.topicus.keyhub.servicecontract.model.auth.TwoFactorAuthenticationStatus;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectoryPrimer;
import nl.topicus.keyhub.servicecontract.model.group.Group;
import nl.topicus.keyhub.servicecontract.model.group.GroupRights;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@OnResource(value="account", rel="koppeling", under=Group.class)
@WriteScope(value={}, rels={@WriteRelation(type=GroupAccount.class, rel="koppeling")})
@PrimerFor(value=GroupAccount.class)
public class GroupAccount
extends AccountPrimer {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @NotNull
    private GroupRights rights;
    @XmlElement
    private LocalDate endDate;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private Instant provisioningEndTime;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private Instant provisioningPermissionEndTime;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean visibleForProvisioning = true;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private AccountDirectoryPrimer directory;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private TwoFactorAuthenticationStatus twoFactorStatus;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private LocalDate lastUsed;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean nested;
    @XmlElement
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private boolean disconnectedNested;

    public GroupAccount() {
    }

    public GroupAccount(AccountPrimer account) {
        this.setLink(account.self());
        this.setUsername(account.getUsername());
    }

    public GroupRights getRights() {
        return this.rights;
    }

    public void setRights(GroupRights rights) {
        this.rights = rights;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Instant getProvisioningEndTime() {
        return this.provisioningEndTime;
    }

    public void setProvisioningEndTime(Instant provisioningEndTime) {
        this.provisioningEndTime = provisioningEndTime;
    }

    public Instant getProvisioningPermissionEndTime() {
        return this.provisioningPermissionEndTime;
    }

    public void setProvisioningPermissionEndTime(Instant provisioningPermissionEndTime) {
        this.provisioningPermissionEndTime = provisioningPermissionEndTime;
    }

    public boolean isVisibleForProvisioning() {
        return this.visibleForProvisioning;
    }

    public void setVisibleForProvisioning(boolean visibleForProvisioning) {
        this.visibleForProvisioning = visibleForProvisioning;
    }

    public AccountDirectoryPrimer getDirectory() {
        return this.directory;
    }

    public void setDirectory(AccountDirectoryPrimer directory) {
        this.directory = directory;
    }

    public TwoFactorAuthenticationStatus getTwoFactorStatus() {
        return this.twoFactorStatus;
    }

    public void setTwoFactorStatus(TwoFactorAuthenticationStatus twoFactorStatus) {
        this.twoFactorStatus = twoFactorStatus;
    }

    public LocalDate getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(LocalDate lastUsed) {
        this.lastUsed = lastUsed;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public boolean isDisconnectedNested() {
        return this.disconnectedNested;
    }

    public void setDisconnectedNested(boolean disconnectedNested) {
        this.disconnectedNested = disconnectedNested;
    }

    public boolean isManagerWithoutEndDate() {
        return GroupRights.MANAGER.equals((Object)this.rights) && this.endDate == null;
    }
}

