/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.keyhub.servicecontract.model.directory;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import nl.topicus.cobra.restcontract.annotation.WriteScope;
import nl.topicus.keyhub.servicecontract.annotations.Sensitive;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectory;
import nl.topicus.keyhub.servicecontract.model.directory.AccountDirectoryType;
import nl.topicus.keyhub.servicecontract.model.directory.DirectoryRotatingPassword;
import nl.topicus.keyhub.servicecontract.model.directory.OIDCVendor;
import nl.topicus.keyhub.servicecontract.model.organization.OrganizationalUnitPrimer;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@WriteScope(value={OIDCDirectory.class})
public class OIDCDirectory
extends AccountDirectory {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @NotBlank
    @Size(max=512)
    private @NotBlank @Size(max=512) String issuer;
    @XmlElement
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String clientId;
    @Sensitive
    @XmlElement
    @NotBlank
    private String clientSecret;
    @XmlElement
    private boolean enforces2fa;
    @XmlElement
    @NotNull
    private OIDCVendor vendor;
    @XmlElement
    @Size(max=512)
    private @Size(max=512) String domainRestriction;
    @XmlElement
    @Size(max=512)
    private @Size(max=512) String logoutUrl;
    @XmlElement
    @Size(max=512)
    private @Size(max=512) String acrValues;
    @XmlElement
    private boolean sendLoginHint;
    @XmlElement
    @Size(max=1024)
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private @Size(max=1024) String fullyResolvedIssuer;
    @XmlElement
    @Size(max=512)
    private @Size(max=512) String attributesToStore;

    public static OIDCDirectory createDefault(OrganizationalUnitPrimer baseOrganizationalUnit) {
        OIDCDirectory newDirectory = new OIDCDirectory();
        newDirectory.setType(AccountDirectoryType.OIDC);
        newDirectory.setActive(true);
        newDirectory.setVendor(OIDCVendor.GENERIC);
        newDirectory.setRotatingPassword(DirectoryRotatingPassword.DEFAULT_OFF);
        newDirectory.setSendLoginHint(true);
        newDirectory.setBaseOrganizationalUnit(baseOrganizationalUnit);
        return newDirectory;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getFullyResolvedIssuer() {
        return this.fullyResolvedIssuer;
    }

    public void setFullyResolvedIssuer(String fullyResolvedIssuer) {
        this.fullyResolvedIssuer = fullyResolvedIssuer;
    }

    public boolean isEnforces2fa() {
        return this.enforces2fa;
    }

    public void setEnforces2fa(boolean enforces2fa) {
        this.enforces2fa = enforces2fa;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OIDCVendor getVendor() {
        return this.vendor;
    }

    public void setVendor(OIDCVendor vendor) {
        this.vendor = vendor;
    }

    public String getDomainRestriction() {
        return this.domainRestriction;
    }

    public void setDomainRestriction(String domainRestriction) {
        this.domainRestriction = domainRestriction;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public boolean isSendLoginHint() {
        return this.sendLoginHint;
    }

    public void setSendLoginHint(boolean sendLoginHint) {
        this.sendLoginHint = sendLoginHint;
    }

    public String getMainDomainRestriction() {
        return this.domainRestriction == null || this.domainRestriction.isEmpty() ? null : this.domainRestriction.split(" ")[0].trim();
    }

    public String getAttributesToStore() {
        return this.attributesToStore;
    }

    public void setAttributesToStore(String attributesToStore) {
        this.attributesToStore = attributesToStore;
    }
}

